/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.repository;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.alfresco.database.connector.AlfrescoMetadataRepository;
import org.alfresco.database.connector.NodeParams;
import org.alfresco.database.connector.model.AlfrescoNode;
import org.alfresco.hxi_connector.bulk_ingester.repository.BulkIngesterRepositoryConfig;
import org.alfresco.hxi_connector.bulk_ingester.repository.IdRange;
import org.alfresco.hxi_connector.bulk_ingester.repository.filter.AlfrescoNodeFilterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BulkIngesterNodeRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkIngesterNodeRepository.class);
    private final AlfrescoMetadataRepository metadataRepository;
    private final BulkIngesterRepositoryConfig bulkIngesterRepositoryConfig;
    private final AlfrescoNodeFilterHandler alfrescoNodeFilterHandler;

    public Stream<AlfrescoNode> find(IdRange idRange) {
        NodeParams nodeParams = NodeParams.searchByIdRange((long)idRange.from(), (long)idRange.to());
        return IntStream.iterate(0, page -> page + 1).mapToObj(page -> nodeParams.withPaging(page, this.bulkIngesterRepositoryConfig.pageSize())).map(this::findNodes).peek(nodes -> log.debug("Found {} nodes", (Object)nodes.size())).takeWhile(Predicate.not(Collection::isEmpty)).flatMap(Collection::stream);
    }

    private List<AlfrescoNode> findNodes(NodeParams nodeParams) {
        log.debug("Looking for nodes: {}", (Object)nodeParams);
        return this.metadataRepository.getAlfrescoNodes(nodeParams).stream().filter(this.alfrescoNodeFilterHandler::filterNode).collect(Collectors.toList());
    }

    @Generated
    public BulkIngesterNodeRepository(AlfrescoMetadataRepository metadataRepository, BulkIngesterRepositoryConfig bulkIngesterRepositoryConfig, AlfrescoNodeFilterHandler alfrescoNodeFilterHandler) {
        this.metadataRepository = metadataRepository;
        this.bulkIngesterRepositoryConfig = bulkIngesterRepositoryConfig;
        this.alfrescoNodeFilterHandler = alfrescoNodeFilterHandler;
    }
}

