/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.processor.mapper.config;

import jakarta.validation.constraints.NotNull;
import java.util.Map;
import lombok.Generated;
import org.alfresco.hxi_connector.bulk_ingester.exception.BulkIngesterRuntimeException;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.NamespacePrefixMapper;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.config.PredefinedNamespacePrefixMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties
@PropertySource(value={"${alfresco.bulk.ingest.namespace-prefixes-mapping}"}, factory=JsonPropertySourceFactory.class)
public class PredefinedNamespacePrefixMapper
implements NamespacePrefixMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PredefinedNamespacePrefixMapper.class);
    @NotNull
    private Map<String, String> prefixUriMap;

    public String toPrefixedName(String namespace, String localName) {
        String prefix = (String)this.prefixUriMap.get(namespace);
        if (prefix == null) {
            throw new BulkIngesterRuntimeException(String.format("Cannot calculate prefixed name of %s (unknown namespace: %s)", localName, namespace));
        }
        return prefix + ":" + localName;
    }

    @Generated
    public PredefinedNamespacePrefixMapper() {
    }

    @Generated
    public Map<String, String> getPrefixUriMap() {
        return this.prefixUriMap;
    }

    @Generated
    public void setPrefixUriMap(Map<String, String> prefixUriMap) {
        this.prefixUriMap = prefixUriMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredefinedNamespacePrefixMapper)) {
            return false;
        }
        PredefinedNamespacePrefixMapper other = (PredefinedNamespacePrefixMapper)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$prefixUriMap = this.getPrefixUriMap();
        Map other$prefixUriMap = other.getPrefixUriMap();
        return !(this$prefixUriMap == null ? other$prefixUriMap != null : !((Object)this$prefixUriMap).equals(other$prefixUriMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PredefinedNamespacePrefixMapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $prefixUriMap = this.getPrefixUriMap();
        result = result * 59 + ($prefixUriMap == null ? 43 : ((Object)$prefixUriMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PredefinedNamespacePrefixMapper(prefixUriMap=" + String.valueOf(this.getPrefixUriMap()) + ")";
    }
}

