/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth;

import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import org.alfresco.hxi_connector.common.adapters.auth.AccessTokenProvider;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.auth.config.properties.AuthProperties;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AuthServiceTest {
    public static final String VALID_TOKEN = "valid-token";
    @Mock
    private AccessTokenProvider mockAccessTokenProvider;
    @Mock
    private AuthProperties mockAuthProperties;
    @Mock
    private AuthProperties.AuthProvider mockAuthProvider;
    @Mock
    private Exchange mockExchange;
    @InjectMocks
    private AuthService objectUnderTest;

    AuthServiceTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.lenient().when((Object)this.mockExchange.getIn()).thenReturn((Object)((Message)Mockito.mock((Object[])new Message[0])));
    }

    @Test
    void givenValidBearerToken_whenSetAlfrescoAuthorizationHeaders_thenBearerHeaderIsSet() {
        BDDMockito.given((Object)this.mockAccessTokenProvider.getAccessToken("alfresco")).willReturn((Object)VALID_TOKEN);
        BDDMockito.given((Object)this.mockAuthProperties.getProviders()).willReturn(Map.of("alfresco", this.mockAuthProvider));
        BDDMockito.given((Object)this.mockAuthProvider.getType()).willReturn((Object)"Bearer ".trim().toLowerCase(Locale.getDefault()));
        this.objectUnderTest.setAlfrescoAuthorizationHeaders(this.mockExchange);
        this.thenExpectedAuthHeadersCleared();
        ((Message)BDDMockito.then((Object)this.mockExchange.getIn()).should()).setHeader("Authorization", (Object)"Bearer valid-token");
    }

    @Test
    void givenBasicAlfrescoAuthProvided_whenSetAlfrescoAuthorizationHeaders_thenBasicHeaderIsSet() {
        BDDMockito.given((Object)this.mockAuthProperties.getProviders()).willReturn(Map.of("alfresco", this.mockAuthProvider));
        BDDMockito.given((Object)this.mockAuthProvider.getType()).willReturn((Object)"Basic ".trim().toLowerCase(Locale.getDefault()));
        String username = "username";
        BDDMockito.given((Object)this.mockAuthProvider.getUsername()).willReturn((Object)username);
        String password = "password";
        BDDMockito.given((Object)this.mockAuthProvider.getPassword()).willReturn((Object)password);
        this.objectUnderTest.setAlfrescoAuthorizationHeaders(this.mockExchange);
        this.thenExpectedAuthHeadersCleared();
        ((Message)BDDMockito.then((Object)this.mockExchange.getIn()).should()).setHeader("Authorization", (Object)("Basic " + AuthServiceTest.getEncodedCredentials(username, password)));
    }

    @Test
    void givenValidBearerToken_whenSetHxIAuthorizationHeaders_thenHeadersAreSet() {
        BDDMockito.given((Object)this.mockAccessTokenProvider.getAccessToken("hyland-experience")).willReturn((Object)VALID_TOKEN);
        BDDMockito.given((Object)this.mockAuthProperties.getProviders()).willReturn(Map.of("hyland-experience", this.mockAuthProvider));
        String dummyEnvKey = "dummy-environment";
        BDDMockito.given((Object)this.mockAuthProvider.getEnvironmentKey()).willReturn((Object)dummyEnvKey);
        this.objectUnderTest.setHxIAuthorizationHeaders(this.mockExchange);
        this.thenExpectedAuthHeadersCleared();
        ((Message)BDDMockito.then((Object)this.mockExchange.getIn()).should()).setHeader("Authorization", (Object)"Bearer valid-token");
        ((Message)BDDMockito.then((Object)this.mockExchange.getIn()).should()).setHeader("Hxp-Environment", (Object)dummyEnvKey);
        ((Message)BDDMockito.then((Object)this.mockExchange.getIn()).should()).setHeader("Hxp-App", (Object)"hxai-discovery");
    }

    @Test
    void testGetHxIAuthHeaders() {
        BDDMockito.given((Object)this.mockAuthProperties.getProviders()).willReturn((Object)((Map)Mockito.mock((Object[])new Map[0])));
        BDDMockito.given((Object)((AuthProperties.AuthProvider)this.mockAuthProperties.getProviders().get("hyland-experience"))).willReturn((Object)((AuthProperties.AuthProvider)Mockito.mock((Object[])new AuthProperties.AuthProvider[0])));
        BDDMockito.given((Object)((AuthProperties.AuthProvider)this.mockAuthProperties.getProviders().get("hyland-experience")).getEnvironmentKey()).willReturn((Object)"test-environment");
        BDDMockito.given((Object)this.mockAccessTokenProvider.getAccessToken("hyland-experience")).willReturn((Object)"token");
        Map headers = this.objectUnderTest.getHxpAuthHeaders();
        Assertions.assertThat((Map)headers).containsExactlyInAnyOrderEntriesOf(Map.of("Authorization", "Bearer token", "Hxp-Environment", "test-environment", "Hxp-App", "hxai-discovery"));
    }

    @Test
    void testGetAlfrescoAuthHeaders() {
        BDDMockito.given((Object)this.mockAuthProperties.getProviders()).willReturn((Object)((Map)Mockito.mock((Object[])new Map[0])));
        BDDMockito.given((Object)((AuthProperties.AuthProvider)this.mockAuthProperties.getProviders().get("alfresco"))).willReturn((Object)((AuthProperties.AuthProvider)Mockito.mock((Object[])new AuthProperties.AuthProvider[0])));
        BDDMockito.given((Object)((AuthProperties.AuthProvider)this.mockAuthProperties.getProviders().get("alfresco")).getType()).willReturn((Object)"Basic");
        BDDMockito.given((Object)((AuthProperties.AuthProvider)this.mockAuthProperties.getProviders().get("alfresco")).getUsername()).willReturn((Object)"user");
        BDDMockito.given((Object)((AuthProperties.AuthProvider)this.mockAuthProperties.getProviders().get("alfresco")).getPassword()).willReturn((Object)"pass");
        Map headers = this.objectUnderTest.getAlfrescoAuthHeaders();
        Assertions.assertThat((Map)headers).containsExactlyEntriesOf(Map.of("Authorization", "Basic " + Base64.getEncoder().encodeToString("user:pass".getBytes())));
    }

    private static String getEncodedCredentials(String username, String password) {
        String valueToEncode = username + ":" + password;
        return Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    private void thenExpectedAuthHeadersCleared() {
        ((Message)BDDMockito.then((Object)this.mockExchange.getIn()).should()).removeHeader("Authorization");
        ((Message)BDDMockito.then((Object)this.mockExchange.getIn()).should()).removeHeader("Hxp-Environment");
        ((Message)BDDMockito.then((Object)this.mockExchange.getIn()).should()).removeHeader("Hxp-App");
    }
}

