/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth;

import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationClient;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationResult;
import org.alfresco.hxi_connector.common.adapters.auth.DefaultAccessTokenProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class DefaultAccessTokenProviderTest {
    private static final String CLIENT_REGISTRATION_ID = "testClient";
    private static final String TEST_TOKEN = "testToken";
    @Mock
    private AuthenticationClient mockAuthenticationClient;
    @InjectMocks
    private DefaultAccessTokenProvider objectUnderTest;

    DefaultAccessTokenProviderTest() {
    }

    @Test
    void givenTokenNotPresent_whenGetAccessToken_thenRefreshToken() {
        AuthenticationResult mockResult = (AuthenticationResult)Mockito.mock(AuthenticationResult.class);
        BDDMockito.given((Object)mockResult.getAccessToken()).willReturn((Object)TEST_TOKEN);
        BDDMockito.given((Object)mockResult.getExpiresIn()).willReturn((Object)3600);
        BDDMockito.given((Object)mockResult.getTemporalUnit()).willReturn((Object)ChronoUnit.SECONDS);
        BDDMockito.given((Object)this.mockAuthenticationClient.authenticate(CLIENT_REGISTRATION_ID)).willReturn((Object)mockResult);
        String token = this.objectUnderTest.getAccessToken(CLIENT_REGISTRATION_ID);
        ((AuthenticationClient)BDDMockito.then((Object)this.mockAuthenticationClient).should()).authenticate(CLIENT_REGISTRATION_ID);
        BDDMockito.then((Object)this.mockAuthenticationClient).shouldHaveNoMoreInteractions();
        Assertions.assertEquals((Object)TEST_TOKEN, (Object)token);
        Map accessTokens = (Map)ReflectionTestUtils.getField((Object)this.objectUnderTest, (String)"accessTokens");
        OffsetDateTime offsetDateTime = OffsetDateTime.now().plusSeconds(3540L).truncatedTo(ChronoUnit.SECONDS);
        Assertions.assertEquals((Object)offsetDateTime, (Object)((DefaultAccessTokenProvider.Token)accessTokens.get(CLIENT_REGISTRATION_ID)).getRefreshAt().truncatedTo(ChronoUnit.SECONDS));
    }

    @Test
    void givenTokenExpired_whenGetAccessToken_thenRefreshToken() {
        AuthenticationResult mockResult = (AuthenticationResult)Mockito.mock(AuthenticationResult.class);
        BDDMockito.given((Object)mockResult.getAccessToken()).willReturn((Object)TEST_TOKEN);
        BDDMockito.given((Object)mockResult.getExpiresIn()).willReturn((Object)3600);
        BDDMockito.given((Object)mockResult.getTemporalUnit()).willReturn((Object)ChronoUnit.SECONDS);
        BDDMockito.given((Object)this.mockAuthenticationClient.authenticate(CLIENT_REGISTRATION_ID)).willReturn((Object)mockResult);
        HashMap<String, DefaultAccessTokenProvider.Token> tokens = new HashMap<String, DefaultAccessTokenProvider.Token>();
        tokens.put(CLIENT_REGISTRATION_ID, new DefaultAccessTokenProvider.Token(TEST_TOKEN, OffsetDateTime.now().minusSeconds(2L)));
        ReflectionTestUtils.setField((Object)this.objectUnderTest, (String)"accessTokens", tokens);
        String token = this.objectUnderTest.getAccessToken(CLIENT_REGISTRATION_ID);
        ((AuthenticationClient)BDDMockito.then((Object)this.mockAuthenticationClient).should()).authenticate(CLIENT_REGISTRATION_ID);
        BDDMockito.then((Object)this.mockAuthenticationClient).shouldHaveNoMoreInteractions();
        Assertions.assertEquals((Object)TEST_TOKEN, (Object)token);
    }

    @Test
    void givenTokenValid_whenGetAccessToken_thenReturnTokenWithoutRefresh() {
        HashMap<String, DefaultAccessTokenProvider.Token> tokens = new HashMap<String, DefaultAccessTokenProvider.Token>();
        tokens.put(CLIENT_REGISTRATION_ID, new DefaultAccessTokenProvider.Token(TEST_TOKEN, OffsetDateTime.now().plusSeconds(2L)));
        ReflectionTestUtils.setField((Object)this.objectUnderTest, (String)"accessTokens", tokens);
        String token = this.objectUnderTest.getAccessToken(CLIENT_REGISTRATION_ID);
        BDDMockito.then((Object)this.mockAuthenticationClient).shouldHaveNoInteractions();
        Assertions.assertEquals((Object)TEST_TOKEN, (Object)token);
    }

    @Test
    void givenAuthenticationError_whenGetAccessToken_thenThrowException() {
        BDDMockito.given((Object)this.mockAuthenticationClient.authenticate(CLIENT_REGISTRATION_ID)).willThrow(RuntimeException.class);
        Assertions.assertThrows(RuntimeException.class, () -> this.objectUnderTest.getAccessToken(CLIENT_REGISTRATION_ID));
    }
}

