/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationResult;
import org.alfresco.hxi_connector.common.adapters.auth.config.properties.AuthProperties;
import org.springframework.test.context.DynamicPropertyRegistry;

public class AuthUtils {
    private static final String CLIENT_NAME = "Dummy Client";
    private static final String CLIENT_ID = "dummy-client";
    private static final String CLIENT_SECRET = "dummy's-client-dummy-secret";
    private static final String ACCESS_TOKEN = "eyJhbGciOiJSUzI1NiIsImtpZCI6IjEyNTE0RTNGREJENEJDMTM5OUE1RjA3NjUxQzU1MTNGQ0Y0RjhDMjUiLCJ4NXQiOiJFbEZPUDl2VXZCT1pwZkIyVWNWUlA4OVBqQ1UiLCJ0eXAiOiJhdCtqd3QifQ.eyJpc3MiOiJodHRwczovL2F1dGguaWFtLnN0YWdpbmcuZXhwZXJpZW5jZS5oeWxhbmQuY29tL2lkcCIsIm5iZiI6MTcwNzQwNjM2MiwiaWF0IjoxNzA3NDA2MzYyLCJleHAiOjE3MDc0MDk5NjIsImF1ZCI6Imh4cCIsInNjb3BlIjpbImh4cC5pbnRlZ3JhdGlvbnMiXSwiYW1yIjpbInVybjpoeWxhbmQ6cGFyYW1zOm9hdXRoOmdyYW50LXR5cGU6YXBpLWNyZWRlbnRpYWxzIl0sImNsaWVudF9pZCI6IjZmODcwYmViLTUwNGEtNDBjZi1iMjlmLWVjY2I2MjAyYjM3YSIsInN1YiI6IjgwOGQ1YzE2LTg0MDQtNGZiYi1hMTczLTUyNmExYzdhM2M0MiIsImF1dGhfdGltZSI6MTcwNzQwNjM2MiwiaWRwIjoibG9jYWwifQ.ghydijmyuwWemWiG0WYeEYDcPeClEcGFhko8EAkZjZmcmfs-rqmy4QFQM8ineOqK8CCHMbdJptxcyEAii7bvjzjh2syc-m0RHuDCpEyT1grMqdJ_uA0t72Edi-azDVsBOtKCI_tW7a_wdcylG1kXuORovGgMmZjeMorJO_JrBzxSQltUlCGZw-yNByRFi9fJgX_UONHc8J4-igeHYRtkgZK1t0c9cJKuOD6Cdp33a5bwibQbdo4nnGuXkXZ9kFE45g2uuzHvCiAYZQIzJ79kGxjFM6Ke-YG2VjEFaHzonqAgPKVkNO4v_vwlaL1Bsuwrj1ul9qHUQ48JyK84G-RNjA";
    private static final int EXPIRES_IN = 3600;
    private static final String TOKEN_TYPE = "Bearer";
    private static final String AUTH_GRAND_TYPE = "auth_grand_type";
    private static final String SCOPE = "hxp.integrations";
    private static final String AUTH_RESPONSE_BODY_PATTERN = "    {\n        \"access_token\": \"%s\",\n        \"expires_in\": %s,\n        \"token_type\": \"%s\",\n        \"scope\": \"%s\"\n    }\n";
    private static final String AUTH_REQUEST_BODY_PATTERN = "grant_type=%s&client_id=%s&client_secret=%s&scope=%s";
    public static final String TEST_ENVIRONMENT_HEADER = "hxai-environment-key";
    public static final String TOKEN_PATH = "/token";
    public static final String AUTH_HEADER = "Bearer eyJhbGciOiJSUzI1NiIsImtpZCI6IjEyNTE0RTNGREJENEJDMTM5OUE1RjA3NjUxQzU1MTNGQ0Y0RjhDMjUiLCJ4NXQiOiJFbEZPUDl2VXZCT1pwZkIyVWNWUlA4OVBqQ1UiLCJ0eXAiOiJhdCtqd3QifQ.eyJpc3MiOiJodHRwczovL2F1dGguaWFtLnN0YWdpbmcuZXhwZXJpZW5jZS5oeWxhbmQuY29tL2lkcCIsIm5iZiI6MTcwNzQwNjM2MiwiaWF0IjoxNzA3NDA2MzYyLCJleHAiOjE3MDc0MDk5NjIsImF1ZCI6Imh4cCIsInNjb3BlIjpbImh4cC5pbnRlZ3JhdGlvbnMiXSwiYW1yIjpbInVybjpoeWxhbmQ6cGFyYW1zOm9hdXRoOmdyYW50LXR5cGU6YXBpLWNyZWRlbnRpYWxzIl0sImNsaWVudF9pZCI6IjZmODcwYmViLTUwNGEtNDBjZi1iMjlmLWVjY2I2MjAyYjM3YSIsInN1YiI6IjgwOGQ1YzE2LTg0MDQtNGZiYi1hMTczLTUyNmExYzdhM2M0MiIsImF1dGhfdGltZSI6MTcwNzQwNjM2MiwiaWRwIjoibG9jYWwifQ.ghydijmyuwWemWiG0WYeEYDcPeClEcGFhko8EAkZjZmcmfs-rqmy4QFQM8ineOqK8CCHMbdJptxcyEAii7bvjzjh2syc-m0RHuDCpEyT1grMqdJ_uA0t72Edi-azDVsBOtKCI_tW7a_wdcylG1kXuORovGgMmZjeMorJO_JrBzxSQltUlCGZw-yNByRFi9fJgX_UONHc8J4-igeHYRtkgZK1t0c9cJKuOD6Cdp33a5bwibQbdo4nnGuXkXZ9kFE45g2uuzHvCiAYZQIzJ79kGxjFM6Ke-YG2VjEFaHzonqAgPKVkNO4v_vwlaL1Bsuwrj1ul9qHUQ48JyK84G-RNjA";

    public static String createAuthResponseBody() {
        return AUTH_RESPONSE_BODY_PATTERN.formatted(ACCESS_TOKEN, 3600, TOKEN_TYPE, SCOPE);
    }

    public static String createAuthRequestBody() {
        return AUTH_REQUEST_BODY_PATTERN.formatted(URLEncoder.encode(AUTH_GRAND_TYPE, StandardCharsets.UTF_8), URLEncoder.encode(CLIENT_ID, StandardCharsets.UTF_8), URLEncoder.encode(CLIENT_SECRET, StandardCharsets.UTF_8), URLEncoder.encode(String.join((CharSequence)",", SCOPE), StandardCharsets.UTF_8));
    }

    public static AuthenticationResult createExpectedAuthResult() {
        return new AuthenticationResult(ACCESS_TOKEN, 3600, (TemporalUnit)ChronoUnit.SECONDS, TOKEN_TYPE, SCOPE, Integer.valueOf(200));
    }

    public static String createAuthorizationHeader() {
        return AUTH_HEADER;
    }

    public static void overrideAuthProperties(DynamicPropertyRegistry registry, String mockServerBaseUrl, String providerId) {
        registry.add("auth.providers." + providerId + ".client-id", () -> CLIENT_ID);
        registry.add("auth.providers." + providerId + ".client-secret", () -> CLIENT_SECRET);
        registry.add("auth.providers." + providerId + ".client-name", () -> CLIENT_NAME);
        registry.add("auth.providers." + providerId + ".grant-type", () -> AUTH_GRAND_TYPE);
        registry.add("auth.providers." + providerId + ".scope", () -> SCOPE);
        registry.add("auth.providers." + providerId + ".token-uri", () -> mockServerBaseUrl + TOKEN_PATH);
    }

    public static AuthProperties.AuthProvider createAuthProvider(String tokenUri) {
        AuthProperties.AuthProvider authProvider = new AuthProperties.AuthProvider();
        authProvider.setClientId(CLIENT_ID);
        authProvider.setType("dummy-type");
        authProvider.setClientSecret(CLIENT_SECRET);
        authProvider.setTokenUri(tokenUri);
        authProvider.setGrantType(AUTH_GRAND_TYPE);
        authProvider.setScope(Set.of(SCOPE));
        authProvider.setEnvironmentKey(TEST_ENVIRONMENT_HEADER);
        return authProvider;
    }

    @Generated
    private AuthUtils() {
    }
}

