/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.messaging.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.DiscoveryApiRepositoryInformation;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DiscoveryApiRepositoryInformationTest {
    private static final String DISCOVERY_ENDPOINT = "http://localhost:8080/alfresco/api/discovery";
    private static final String BEARER_TOKEN = "Bearer token";
    @Mock
    private AuthService authServiceMock;
    @Mock
    private HttpClient httpClientMock;
    @Mock
    private HttpResponse httpResponseMock;
    private final ObjectMapper objectMapper = new ObjectMapper();

    DiscoveryApiRepositoryInformationTest() {
    }

    @Test
    void givenVersionOverrideIsEmptyAndApiReturnsVersion_whenGetRepositoryVersion_thenReturnApiVersion() throws IOException, InterruptedException {
        BDDMockito.given((Object)this.authServiceMock.getAuthHeader("alfresco")).willReturn(Map.entry("Authorization", BEARER_TOKEN));
        BDDMockito.given(this.httpClientMock.send((HttpRequest)ArgumentMatchers.any(HttpRequest.class), (HttpResponse.BodyHandler)ArgumentMatchers.any(HttpResponse.BodyHandler.class))).willReturn((Object)this.httpResponseMock);
        BDDMockito.given((Object)this.httpResponseMock.statusCode()).willReturn((Object)200);
        BDDMockito.given(this.httpResponseMock.body()).willReturn((Object)"{\n    \"entry\": {\n        \"repository\": {\n            \"id\": \"eb4c123a-5621-4583-98a2-739379e3a345\",\n            \"edition\": \"Enterprise\",\n            \"version\": {\n                \"major\": \"23\",\n                \"minor\": \"2\",\n                \"patch\": \"2\",\n                \"hotfix\": \"0\",\n                \"schema\": 19200,\n                \"label\": \"rc50a6313-blocal\",\n                \"display\": \"23.2.2.0 (rc50a6313-blocal) schema 19200\"\n            }\n        }\n    }\n}\n");
        DiscoveryApiRepositoryInformation objectUnderTest = new DiscoveryApiRepositoryInformation(DISCOVERY_ENDPOINT, this.authServiceMock, this.objectMapper, this.httpClientMock);
        String actualVersion = objectUnderTest.getRepositoryVersion();
        String expectedApiVersion = "23.2.2";
        Assertions.assertEquals((Object)expectedApiVersion, (Object)actualVersion);
    }

    @Test
    void givenDiscoverApiFails_whenGetRepositoryVersion_thenThrowException() throws IOException, InterruptedException {
        BDDMockito.given((Object)this.authServiceMock.getAuthHeader("alfresco")).willReturn(Map.entry("Authorization", BEARER_TOKEN));
        BDDMockito.given(this.httpClientMock.send((HttpRequest)ArgumentMatchers.any(HttpRequest.class), (HttpResponse.BodyHandler)ArgumentMatchers.any(HttpResponse.BodyHandler.class))).willThrow(new Throwable[]{new IOException()});
        DiscoveryApiRepositoryInformation objectUnderTest = new DiscoveryApiRepositoryInformation(DISCOVERY_ENDPOINT, this.authServiceMock, this.objectMapper, this.httpClientMock);
        Assertions.assertThrows(EndpointServerErrorException.class, () -> ((DiscoveryApiRepositoryInformation)objectUnderTest).getRepositoryVersion());
    }
}

