/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth;

import ch.qos.logback.core.read.ListAppender;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationClient;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationResult;
import org.alfresco.hxi_connector.common.adapters.auth.DefaultAuthenticationClient;
import org.alfresco.hxi_connector.common.adapters.auth.util.AuthUtils;
import org.alfresco.hxi_connector.common.exception.EndpointClientErrorException;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.common.test.docker.util.DockerContainers;
import org.alfresco.hxi_connector.common.test.util.LoggingUtils;
import org.apache.camel.LoggingLevel;
import org.apache.hc.core5.http.ContentType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.testcontainers.junit.jupiter.Container;
import org.wiremock.integrations.testcontainers.WireMockContainer;

public abstract class DefaultAuthenticationClientTest {
    protected static final int RETRY_ATTEMPTS = 3;
    protected static final int RETRY_DELAY_MS = 0;
    @Container
    protected static final WireMockContainer hxAuthMock = DockerContainers.createWireMockContainer();
    @SpyBean
    protected AuthenticationClient authenticationClient;

    @BeforeAll
    protected static void beforeAll() {
        WireMock.configureFor((String)hxAuthMock.getHost(), (int)hxAuthMock.getPort());
    }

    @Test
    protected void testAuthorize() {
        WireMock.givenThat((MappingBuilder)WireMock.post((String)"/token").willReturn(WireMock.aResponse().withStatus(200).withBody(AuthUtils.createAuthResponseBody())));
        AuthenticationResult authenticationResult = this.authenticationClient.authenticate("hyland-experience");
        ((AuthenticationClient)BDDMockito.then((Object)this.authenticationClient).should()).authenticate("hyland-experience");
        String authRequestBody = AuthUtils.createAuthRequestBody();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withHeader("Host", (StringValuePattern)new EqualToPattern(hxAuthMock.getHost() + ":" + hxAuthMock.getPort())).withHeader("Content-Type", (StringValuePattern)new EqualToPattern(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())).withHeader("Content-Length", (StringValuePattern)new EqualToPattern(String.valueOf(authRequestBody.getBytes(StandardCharsets.UTF_8).length))).withRequestBody((ContentPattern)new EqualToPattern(authRequestBody)));
        AuthenticationResult expectedAuthenticationResult = AuthUtils.createExpectedAuthResult();
        Assertions.assertThat((Object)authenticationResult).isEqualTo((Object)expectedAuthenticationResult);
    }

    @Test
    protected void testAuthorize_serverError_doRetry() {
        ListAppender authLogsAppender = LoggingUtils.createLogsListAppender(DefaultAuthenticationClient.class, (Class[])new Class[0]);
        WireMock.givenThat((MappingBuilder)WireMock.post((String)"/token").willReturn(WireMock.serverError().withResponseBody(new Body(DefaultAuthenticationClientTest.jsonErrorBody("Server error")))));
        Throwable thrown = Assertions.catchThrowable(() -> this.authenticationClient.authenticate("hyland-experience"));
        ((AuthenticationClient)BDDMockito.then((Object)this.authenticationClient).should(Mockito.times((int)3))).authenticate("hyland-experience");
        Assertions.assertThat((Throwable)thrown).isInstanceOf(EndpointServerErrorException.class);
        String expectedErrorLog = DefaultAuthenticationClientTest.createExpectedErrorLog("Server error");
        Condition errorLog = new Condition(log -> log.equals(expectedErrorLog), "error log", new Object[0]);
        Assertions.assertThat((List)authLogsAppender.list).extracting(Objects::toString).areExactly(3, errorLog);
    }

    @Test
    protected void testAuthorize_clientError_dontRetry() {
        ListAppender authLogsAppender = LoggingUtils.createLogsListAppender(DefaultAuthenticationClient.class, (Class[])new Class[0]);
        WireMock.givenThat((MappingBuilder)WireMock.post((String)"/token").willReturn(WireMock.badRequest().withResponseBody(new Body(DefaultAuthenticationClientTest.jsonErrorBody("Bad request")))));
        Throwable thrown = Assertions.catchThrowable(() -> this.authenticationClient.authenticate("hyland-experience"));
        ((AuthenticationClient)BDDMockito.then((Object)this.authenticationClient).should(Mockito.times((int)1))).authenticate("hyland-experience");
        Assertions.assertThat((Throwable)thrown).isInstanceOf(EndpointClientErrorException.class);
        String expectedErrorLog = DefaultAuthenticationClientTest.createExpectedErrorLog("Bad request");
        Assertions.assertThat((List)authLogsAppender.list).extracting(Objects::toString).contains((Object[])new String[]{expectedErrorLog});
    }

    protected static String jsonErrorBody(String errorMessage) {
        return "{\"error\": \"" + errorMessage + "\"}";
    }

    private static String createExpectedErrorLog(String errorMessage) {
        return "[%s] ".concat("Authentication :: failed to authenticate with authorization provider: {}. Response body: {}".replace("{}", "%s")).formatted(LoggingLevel.ERROR.name(), "hyland-experience", DefaultAuthenticationClientTest.jsonErrorBody(errorMessage));
    }

    @Generated
    protected DefaultAuthenticationClientTest() {
    }
}

