/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.messaging.repository;

import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.AcsHealthProbe;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AcsHealthProbeTest {
    private static final String ACS_HEALTH_ENDPOINT = "http://localhost:8080/alfresco";
    private static final int RETRY_TIMEOUT_SECONDS = 3;
    private static final int RETRY_INTERVAL_SECONDS = 1;
    @Mock
    private HttpClient clientMock;
    @Mock
    private HttpResponse<String> responseMock;
    private AcsHealthProbe objectUnderTest;

    AcsHealthProbeTest() {
    }

    @BeforeEach
    void setUp() {
        this.objectUnderTest = new AcsHealthProbe(this.clientMock, ACS_HEALTH_ENDPOINT, 3, 1, true);
    }

    @Test
    void givenAcsIsAlive_whenProbeSent_thenReturnSuccessfully() throws Exception {
        BDDMockito.given(this.clientMock.send((HttpRequest)ArgumentMatchers.any(HttpRequest.class), (HttpResponse.BodyHandler)ArgumentMatchers.any(HttpResponse.BodyHandler.class))).willReturn(this.responseMock);
        BDDMockito.given((Object)this.responseMock.statusCode()).willReturn((Object)200);
        this.objectUnderTest.checkAcsAlive();
        ((HttpClient)BDDMockito.then((Object)this.clientMock).should(Mockito.times((int)1))).send((HttpRequest)ArgumentMatchers.any(HttpRequest.class), (HttpResponse.BodyHandler)ArgumentMatchers.any(HttpResponse.BodyHandler.class));
    }

    @Test
    void givenAcsCallThrowsException_whenProbeSent_thenThrowEndpointServerErrorException() throws Exception {
        BDDMockito.given(this.clientMock.send((HttpRequest)ArgumentMatchers.any(HttpRequest.class), (HttpResponse.BodyHandler)ArgumentMatchers.any(HttpResponse.BodyHandler.class))).willThrow(new Throwable[]{new IOException()});
        Assertions.assertThrows(EndpointServerErrorException.class, () -> ((AcsHealthProbe)this.objectUnderTest).checkAcsAlive());
        ((HttpClient)BDDMockito.then((Object)this.clientMock).should(Mockito.times((int)3))).send((HttpRequest)ArgumentMatchers.any(HttpRequest.class), (HttpResponse.BodyHandler)ArgumentMatchers.any(HttpResponse.BodyHandler.class));
    }

    @Test
    void givenAcsIsNotAvailableWithinTimeout_whenProbeSent_throwEndpointServerErrorException() throws Exception {
        BDDMockito.given(this.clientMock.send((HttpRequest)ArgumentMatchers.any(HttpRequest.class), (HttpResponse.BodyHandler)ArgumentMatchers.any(HttpResponse.BodyHandler.class))).willReturn(this.responseMock);
        BDDMockito.given((Object)this.responseMock.statusCode()).willReturn((Object)500);
        Assertions.assertThrows(EndpointServerErrorException.class, () -> ((AcsHealthProbe)this.objectUnderTest).checkAcsAlive());
        ((HttpClient)BDDMockito.then((Object)this.clientMock).should(Mockito.times((int)3))).send((HttpRequest)ArgumentMatchers.any(HttpRequest.class), (HttpResponse.BodyHandler)ArgumentMatchers.any(HttpResponse.BodyHandler.class));
    }
}

