/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.messaging.repository;

import org.alfresco.hxi_connector.common.adapters.messaging.repository.ApplicationInfoProvider;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.RepositoryInformation;
import org.alfresco.hxi_connector.common.config.properties.Application;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.util.ReflectionTestUtils;
import uk.org.webcompere.systemstubs.jupiter.SystemStub;
import uk.org.webcompere.systemstubs.jupiter.SystemStubsExtension;
import uk.org.webcompere.systemstubs.properties.SystemProperties;

@ExtendWith(value={MockitoExtension.class, SystemStubsExtension.class})
class ApplicationInfoProviderTest {
    @SystemStub
    private SystemProperties systemProperties;
    @Mock
    private RepositoryInformation repositoryInformationMock;
    @Mock
    private Application applicationPropertiesMock;

    ApplicationInfoProviderTest() {
    }

    @Test
    void givenNoUserDataYetFetched_whenGetUserAgentData_thenCallAcsApiAndCalculateData() {
        BDDMockito.given((Object)this.applicationPropertiesMock.getVersion()).willReturn((Object)"1.0.0");
        BDDMockito.given((Object)this.repositoryInformationMock.getRepositoryVersion()).willReturn((Object)"23.2.0");
        this.systemProperties.set("os.name", "Windows");
        this.systemProperties.set("os.version", "10");
        this.systemProperties.set("os.arch", "amd64");
        ApplicationInfoProvider objectUnderTest = new ApplicationInfoProvider(this.repositoryInformationMock, this.applicationPropertiesMock);
        String expectedUserAgentData = "ACS HXI Connector/1.0.0 ACS/23.2.0 (Windows 10 amd64)";
        String actualUserAgentData = objectUnderTest.getUserAgentData();
        Assertions.assertEquals((Object)expectedUserAgentData, (Object)actualUserAgentData);
        ((RepositoryInformation)BDDMockito.then((Object)this.repositoryInformationMock).should()).getRepositoryVersion();
    }

    @Test
    void givenUserDataFetched_whenGetUserAgentData_thenGetDataWithoutCalculation() {
        ApplicationInfoProvider objectUnderTest = new ApplicationInfoProvider(this.repositoryInformationMock, this.applicationPropertiesMock);
        ReflectionTestUtils.setField((Object)objectUnderTest, (String)"applicationInfo", (Object)"ACS HXI Connector/1.0.0 ACS/23.2.0 (Windows 10 amd64)");
        String expectedUserAgentData = "ACS HXI Connector/1.0.0 ACS/23.2.0 (Windows 10 amd64)";
        String actualUserAgentData = objectUnderTest.getUserAgentData();
        Assertions.assertEquals((Object)expectedUserAgentData, (Object)actualUserAgentData);
        BDDMockito.then((Object)this.applicationPropertiesMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.repositoryInformationMock).shouldHaveNoInteractions();
    }
}

