/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class TokenRequest {
    private String grantType;
    private String clientId;
    private String clientSecret;
    private Set<String> scope;
    private String username;
    private String password;

    public String getTokenRequestBody() {
        StringBuilder body = new StringBuilder();
        body.append("grant_type=").append(URLEncoder.encode(this.grantType, StandardCharsets.UTF_8)).append("&client_id=").append(URLEncoder.encode(this.clientId, StandardCharsets.UTF_8));
        if (StringUtils.isNotBlank((CharSequence)this.clientSecret)) {
            body.append("&client_secret=").append(URLEncoder.encode(this.clientSecret, StandardCharsets.UTF_8));
        }
        if (!CollectionUtils.isEmpty(this.scope)) {
            body.append("&scope=").append(URLEncoder.encode(String.join((CharSequence)" ", this.scope), StandardCharsets.UTF_8));
        }
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            body.append("&username=").append(URLEncoder.encode(this.username, StandardCharsets.UTF_8));
        }
        if (StringUtils.isNotBlank((CharSequence)this.password)) {
            body.append("&password=").append(URLEncoder.encode(this.password, StandardCharsets.UTF_8));
        }
        return body.toString();
    }

    @Generated
    public static TokenRequestBuilder builder() {
        return new TokenRequestBuilder();
    }

    @Generated
    public TokenRequest(String grantType, String clientId, String clientSecret, Set<String> scope, String username, String password) {
        this.grantType = grantType;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.username = username;
        this.password = password;
    }

    @Generated
    public String toString() {
        return "TokenRequest(grantType=" + this.grantType + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scope=" + String.valueOf(this.scope) + ", username=" + this.username + ", password=" + this.password + ")";
    }

    @Generated
    public static class TokenRequestBuilder {
        @Generated
        private String grantType;
        @Generated
        private String clientId;
        @Generated
        private String clientSecret;
        @Generated
        private Set<String> scope;
        @Generated
        private String username;
        @Generated
        private String password;

        @Generated
        TokenRequestBuilder() {
        }

        @Generated
        public TokenRequestBuilder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        @Generated
        public TokenRequestBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public TokenRequestBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Generated
        public TokenRequestBuilder scope(Set<String> scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public TokenRequestBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public TokenRequestBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public TokenRequest build() {
            return new TokenRequest(this.grantType, this.clientId, this.clientSecret, this.scope, this.username, this.password);
        }

        @Generated
        public String toString() {
            return "TokenRequest.TokenRequestBuilder(grantType=" + this.grantType + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scope=" + String.valueOf(this.scope) + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

