/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.test.docker.util;

import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;

public class DockerTags {
    private static final String REPOSITORY_TAG_DEFAULT = "23.2.1";
    private static final String POSTGRES_TAG_DEFAULT = "14.4";
    private static final String ACTIVEMQ_TAG_DEFAULT = "5.18.3-jre17-rockylinux8";
    private static final String WIREMOCK_TAG_DEFAULT = "3.4.2";
    private static final String LOCALSTACK_TAG_DEFAULT = "3.2.0";
    private static final String TRANSFORM_ROUTER_TAG_DEFAULT = "4.0.1";
    private static final String TRANSFORM_CORE_AIO_TAG_DEFAULT = "5.0.1";
    private static final String SFS_TAG_DEFAULT = "4.0.1";
    private static final String PROPERTIES_FILE = "docker-tags.properties";
    private static Properties properties;

    public static String getProperty(String key) {
        String value;
        if (properties == null) {
            DockerTags.loadProperties();
        }
        if ((value = properties.getProperty(key)) == null) {
            throw new NoSuchElementException("Property: '" + key + "' not found");
        }
        if (value.startsWith("@") && value.endsWith("@")) {
            throw new IllegalArgumentException("Value: '" + value + "' not resolved for property: '" + key + "'");
        }
        return value;
    }

    public static String getOrDefault(String propertyKey, String defaultValue) {
        String property;
        if (properties == null) {
            DockerTags.loadProperties(false);
        }
        String value = defaultValue;
        if (properties != null && (property = properties.getProperty(propertyKey)) != null && !property.startsWith("@") && !property.endsWith("@")) {
            value = property;
        }
        return value;
    }

    public static Set<Object> keySet() {
        if (properties == null) {
            DockerTags.loadProperties();
        }
        return properties.keySet();
    }

    public static String getRepositoryTag() {
        return DockerTags.getOrDefault("repository.tag", REPOSITORY_TAG_DEFAULT);
    }

    public static String getPostgresTag() {
        return DockerTags.getOrDefault("postgres.tag", POSTGRES_TAG_DEFAULT);
    }

    public static String getActiveMqTag() {
        return DockerTags.getOrDefault("activemq.tag", ACTIVEMQ_TAG_DEFAULT);
    }

    public static String getWiremockTag() {
        return DockerTags.getOrDefault("wiremock.tag", WIREMOCK_TAG_DEFAULT);
    }

    public static String getLocalStackTag() {
        return DockerTags.getOrDefault("localstack.tag", LOCALSTACK_TAG_DEFAULT);
    }

    public static String getTransformRouterTag() {
        return DockerTags.getOrDefault("transform.router.tag", "4.0.1");
    }

    public static String getTransformCoreAioTag() {
        return DockerTags.getOrDefault("transform.core.aio.tag", TRANSFORM_CORE_AIO_TAG_DEFAULT);
    }

    public static String getSfsTag() {
        return DockerTags.getOrDefault("sfs.tag", "4.0.1");
    }

    public static String getHxiConnectorTag() {
        return DockerTags.getProperty("hxi.connector.tag");
    }

    private static void loadProperties() {
        DockerTags.loadProperties(true);
    }

    private static void loadProperties(boolean failOnMissingFile) {
        InputStream propertiesStream = DockerTags.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);
        try {
            if (propertiesStream != null) {
                properties = new Properties();
                properties.load(propertiesStream);
            } else if (failOnMissingFile) {
                throw new NoSuchFileException("File: target/test-classes/'docker-tags.properties' not found");
            }
        }
        finally {
            if (Collections.singletonList(propertiesStream).get(0) != null) {
                propertiesStream.close();
            }
        }
    }

    @Generated
    private DockerTags() {
    }
}

