/*
 * #%L
 * Alfresco HX Insight Connector
 * %%
 * Copyright (C) 2023 - 2024 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software.
 * If the software was purchased under a paid Alfresco license, the terms of
 * the paid license agreement will prevail.  Otherwise, the software is
 * provided under the following open source license terms:
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.alfresco.hxi_connector.common.util;

import static lombok.AccessLevel.PRIVATE;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;

import lombok.NoArgsConstructor;

import org.alfresco.hxi_connector.common.exception.ValidationException;

@NoArgsConstructor(access = PRIVATE)
public class EnsureUtils
{
    public static void ensurePositive(int i, String errorMessage, Object... formatArgs)
    {
        ensureThat(i > 0, errorMessage, formatArgs);
    }

    public static void ensureNotBlank(String s, String errorMessage, Object... formatArgs)
    {
        ensureThat(Objects.nonNull(s) && !s.isBlank(), errorMessage, formatArgs);
    }

    public static void ensureNonNull(Object o, String errorMessage, Object... formatArgs)
    {
        ensureThat(Objects.nonNull(o), errorMessage, formatArgs);
    }

    public static void ensureNotNullOrEmpty(Collection<?> collection, String errorMessage, Object... formatArgs)
    {
        ensureThat(Objects.nonNull(collection) && !collection.isEmpty(), errorMessage, formatArgs);
    }

    public static void ensureThat(boolean isOk, String errorMessage, Object... formatArgs)
    {
        ensureThat(isOk, () -> new ValidationException(String.format(errorMessage, formatArgs)));
    }

    public static void ensureThat(boolean isOk, Supplier<? extends RuntimeException> exceptionSupplier)
    {
        if (!isOk)
        {
            throw exceptionSupplier.get();
        }
    }
}
