/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.util;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.alfresco.hxi_connector.common.exception.ValidationException;

public class EnsureUtils {
    public static void ensurePositive(int i, String errorMessage, Object ... formatArgs) {
        EnsureUtils.ensureThat(i > 0, errorMessage, formatArgs);
    }

    public static void ensureNotBlank(String s, String errorMessage, Object ... formatArgs) {
        EnsureUtils.ensureThat(Objects.nonNull(s) && !s.isBlank(), errorMessage, formatArgs);
    }

    public static void ensureNonNull(Object o, String errorMessage, Object ... formatArgs) {
        EnsureUtils.ensureThat(Objects.nonNull(o), errorMessage, formatArgs);
    }

    public static void ensureNotNullOrEmpty(Collection<?> collection, String errorMessage, Object ... formatArgs) {
        EnsureUtils.ensureThat(Objects.nonNull(collection) && !collection.isEmpty(), errorMessage, formatArgs);
    }

    public static void ensureThat(boolean isOk, String errorMessage, Object ... formatArgs) {
        EnsureUtils.ensureThat(isOk, () -> new ValidationException(String.format(errorMessage, formatArgs)));
    }

    public static void ensureThat(boolean isOk, Supplier<? extends RuntimeException> exceptionSupplier) {
        if (!isOk) {
            throw exceptionSupplier.get();
        }
    }

    @Generated
    private EnsureUtils() {
    }
}

