/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.domain.usecase.content;

import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.storage.IngestionEngineStorageClient;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.storage.model.IngestContentResponse;
import org.alfresco.hxi_connector.live_ingester.domain.ports.transform_engine.TransformEngineFileStorage;
import org.alfresco.hxi_connector.live_ingester.domain.ports.transform_engine.TransformRequest;
import org.alfresco.hxi_connector.live_ingester.domain.ports.transform_engine.TransformRequester;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.IngestContentCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.TriggerContentIngestionCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.model.EmptyRenditionException;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.model.File;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.IngestNodeCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.IngestNodeCommandHandler;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.EventType;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property.ContentPropertyUpdated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IngestContentCommandHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IngestContentCommandHandler.class);
    private final TransformRequester transformRequester;
    private final IngestNodeCommandHandler ingestNodeCommandHandler;
    private final TransformEngineFileStorage transformEngineFileStorage;
    private final IngestionEngineStorageClient ingestionEngineStorageClient;

    public void handle(TriggerContentIngestionCommand command) {
        TransformRequest transformRequest = new TransformRequest(command.nodeId(), command.mimeType(), command.timestamp());
        this.transformRequester.requestTransform(transformRequest);
    }

    public void handle(IngestContentCommand command) {
        String fileId = command.transformedFileId();
        String nodeId = command.nodeId();
        File downloadedFile = this.transformEngineFileStorage.downloadFile(fileId);
        EnsureUtils.ensureThat((!downloadedFile.isEmpty() ? 1 : 0) != 0, () -> new EmptyRenditionException(nodeId));
        log.atDebug().log("Transform :: Rendition download complete for node: {} as file with ID: {}", (Object)nodeId, (Object)fileId);
        IngestContentResponse ingestContentResponse = this.ingestionEngineStorageClient.upload(downloadedFile, command.mimeType(), nodeId);
        Set<ContentPropertyUpdated> properties = Set.of(PropertyDelta.contentPropertyUpdated((String)"cm:content", (String)ingestContentResponse.transferId(), (String)ingestContentResponse.mimeType()));
        IngestNodeCommand ingestNodeCommand = new IngestNodeCommand(nodeId, EventType.CREATE_OR_UPDATE, properties, command.timestamp());
        log.atDebug().log("Ingestion :: Notifying about node: {} content upload within transfer with ID: {}", (Object)nodeId, (Object)ingestContentResponse.transferId());
        this.ingestNodeCommandHandler.handle(ingestNodeCommand);
    }

    @Generated
    public IngestContentCommandHandler(TransformRequester transformRequester, IngestNodeCommandHandler ingestNodeCommandHandler, TransformEngineFileStorage transformEngineFileStorage, IngestionEngineStorageClient ingestionEngineStorageClient) {
        this.transformRequester = transformRequester;
        this.ingestNodeCommandHandler = ingestNodeCommandHandler;
        this.transformEngineFileStorage = transformEngineFileStorage;
        this.ingestionEngineStorageClient = ingestionEngineStorageClient;
    }
}

