/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.hxi_extension.rest.api.QuestionsEntityResource;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.AnswerModel;
import org.alfresco.hxi_connector.hxi_extension.service.QuestionService;
import org.alfresco.hxi_connector.hxi_extension.service.model.AnswerResponse;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RelationshipResource(name="answers", title="Answers to questions about documents", entityResource=QuestionsEntityResource.class)
public class QuestionAnswersRelation
implements RelationshipResourceAction.ReadById<AnswerModel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuestionAnswersRelation.class);
    private final QuestionService questionService;

    @WebApiDescription(title="Get answers to a question")
    public AnswerModel readById(String questionId, String id, Parameters parameters) throws RelationshipResourceNotFoundException {
        EnsureUtils.ensureThat(id.equals("-default-"), () -> new EntityNotFoundException(String.format("%s (you should use id '-default-')", id)));
        AnswerResponse hxInsightAnswer = this.questionService.getAnswer(questionId);
        return AnswerModel.fromServiceModel(hxInsightAnswer);
    }

    @Generated
    public QuestionAnswersRelation(QuestionService questionService) {
        this.questionService = questionService;
    }
}

