/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.ApplicationInfoProvider;
import org.alfresco.hxi_connector.hxi_extension.service.config.HxInsightClientConfig;
import org.alfresco.hxi_connector.hxi_extension.service.model.Agent;
import org.alfresco.hxi_connector.hxi_extension.service.model.AnswerResponse;
import org.alfresco.hxi_connector.hxi_extension.service.model.Feedback;
import org.alfresco.hxi_connector.hxi_extension.service.model.FeedbackType;
import org.alfresco.hxi_connector.hxi_extension.service.model.Question;
import org.alfresco.hxi_connector.hxi_extension.service.model.QuestionResponse;
import org.alfresco.hxi_connector.hxi_extension.service.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.WebScriptException;

public class HxInsightClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HxInsightClient.class);
    private final HxInsightClientConfig config;
    private final AuthService authService;
    private final ObjectMapper objectMapper;
    private final HttpClient client;
    private final ApplicationInfoProvider applicationInfoProvider;

    public List<Agent> getAgents() {
        try {
            String url = String.format("%s?sourceId=%s", this.config.getAgentsUrl(), this.applicationInfoProvider.getSourceId());
            HttpRequest request = this.requestWithRequiredHeaders().uri(URI.create(url)).header("Content-Type", "application/json").GET().build();
            HttpResponse<String> httpResponse = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            HttpUtils.ensureCorrectHttpStatusReturned(200, httpResponse);
            return (List)this.objectMapper.readValue(httpResponse.body(), (TypeReference)new TypeReference<List<Agent>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new WebScriptException(503, "Failed to ask question", (Throwable)e);
        }
    }

    public String askQuestion(String agentId, Question question) {
        try {
            String body = this.objectMapper.writeValueAsString((Object)question);
            HttpRequest request = this.requestWithRequiredHeaders().uri(URI.create(String.format(this.config.getQuestionsUrl(), agentId))).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
            HttpResponse<String> httpResponse = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            HttpUtils.ensureCorrectHttpStatusReturned(202, httpResponse);
            return ((QuestionResponse)this.objectMapper.readValue(httpResponse.body(), QuestionResponse.class)).getQuestionId();
        }
        catch (IOException | InterruptedException e) {
            throw new WebScriptException(503, "Failed to ask question", (Throwable)e);
        }
    }

    public AnswerResponse getAnswer(String questionId, String userId) {
        try {
            HttpRequest request = this.requestWithRequiredHeaders().uri(URI.create(String.format(this.config.getAnswersUrl() + "?userId=%s", questionId, userId))).GET().build();
            HttpResponse<String> httpResponse = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            log.atDebug().log("Question with id {} received a following answer {}", (Object)questionId, (Object)httpResponse.body());
            HttpUtils.ensureCorrectHttpStatusReturned(200, httpResponse);
            return (AnswerResponse)this.objectMapper.readValue(httpResponse.body(), AnswerResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new WebScriptException(503, String.format("Failed to get answer to question with id %s", questionId), (Throwable)e);
        }
    }

    public void submitFeedback(String questionId, Feedback feedback) {
        try {
            String body = this.objectMapper.writeValueAsString((Object)feedback);
            HttpRequest request = this.requestWithRequiredHeaders().uri(URI.create(String.format(this.config.getFeedbackUrl(), questionId))).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
            HttpResponse<String> httpResponse = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            HttpUtils.ensureCorrectHttpStatusReturned(200, httpResponse);
        }
        catch (IOException | InterruptedException e) {
            throw new WebScriptException(503, String.format("Failed to submit feedback for question with id %s", questionId), (Throwable)e);
        }
    }

    public String retryQuestion(String agentId, String questionId, String comments, Question question) {
        this.submitFeedback(questionId, Feedback.builder().feedbackType(FeedbackType.RETRY).comments(comments).build());
        return this.askQuestion(agentId, question);
    }

    private HttpRequest.Builder requestWithRequiredHeaders() {
        return HttpRequest.newBuilder().header("User-Agent", this.applicationInfoProvider.getUserAgentData()).headers(this.getAuthHeaders());
    }

    private String[] getAuthHeaders() {
        return (String[])this.authService.getHxpAuthHeaders().entrySet().stream().flatMap(header -> Stream.of((String)header.getKey(), (String)header.getValue())).toArray(String[]::new);
    }

    @Generated
    public HxInsightClient(HxInsightClientConfig config, AuthService authService, ObjectMapper objectMapper, HttpClient client, ApplicationInfoProvider applicationInfoProvider) {
        this.config = config;
        this.authService = authService;
        this.objectMapper = objectMapper;
        this.client = client;
        this.applicationInfoProvider = applicationInfoProvider;
    }
}

