/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.service;

import java.util.Optional;
import lombok.Generated;
import org.alfresco.hxi_connector.hxi_extension.service.HxInsightClient;
import org.alfresco.hxi_connector.hxi_extension.service.model.AnswerResponse;
import org.alfresco.hxi_connector.hxi_extension.service.model.Question;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;

public class QuestionService {
    private final HxInsightClient hxInsightClient;
    private final AuthenticationService authenticationService;
    private final PersonService personService;

    public String askQuestion(String agentId, Question question) {
        question.setUserId(this.getUserId());
        return this.hxInsightClient.askQuestion(agentId, question);
    }

    public AnswerResponse getAnswer(String questionId) {
        return this.hxInsightClient.getAnswer(questionId, this.getUserId());
    }

    public String retryQuestion(String agentId, String questionId, String comments, Question question) {
        question.setUserId(this.getUserId());
        return this.hxInsightClient.retryQuestion(agentId, questionId, comments, question);
    }

    private String getUserId() {
        NodeRef currentUserNodeRef = this.personService.getPersonOrNull(this.authenticationService.getCurrentUserName());
        return Optional.ofNullable(currentUserNodeRef).map(NodeRef::getId).orElse(null);
    }

    @Generated
    public QuestionService(HxInsightClient hxInsightClient, AuthenticationService authenticationService, PersonService personService) {
        this.hxInsightClient = hxInsightClient;
        this.authenticationService = authenticationService;
        this.personService = personService;
    }
}

