/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.messaging.repository;

import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.AcsHealthProbe;
import org.apache.camel.CamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ProcessingStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessingStarter.class);
    private final CamelContext camelContext;

    @EventListener(value={AcsHealthProbe.AcsHealthy.class})
    public void startProcessing() throws Exception {
        log.info("Starting Camel routes: \n\t{}", (Object)this.getRoutesIds());
        this.camelContext.getRouteController().startAllRoutes();
        while (this.camelContext.getRouteController().isStartingRoutes()) {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        log.atInfo().log("All Camel routes started successfully");
    }

    private String getRoutesIds() {
        return this.camelContext.getRoutes().stream().map(route -> route.getId().concat(" - ").concat(route.getEndpoint().toString())).collect(Collectors.joining("\n\t"));
    }

    @Generated
    public ProcessingStarter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

