/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.apache.commons.validator.routines.UrlValidator;

@EntityResource(name="config", title="Hyland Experience Insight Configuration")
public class ConfigEntityResource
implements EntityResourceAction.ReadById<HxIConfig> {
    private final HxIConfig config;

    public ConfigEntityResource(String knowledgeRetrievalUrl) {
        this.config = new HxIConfig(knowledgeRetrievalUrl);
    }

    public HxIConfig readById(String id, Parameters parameters) throws EntityNotFoundException {
        if (!id.equals("-default-")) {
            throw new EntityNotFoundException(String.format("%s (you should use id '-default-')", id));
        }
        return this.config;
    }

    public static class HxIConfig {
        private final String knowledgeRetrievalUrl;

        public HxIConfig(String knowledgeRetrievalUrl) {
            EnsureUtils.ensureNotBlank(knowledgeRetrievalUrl, "Knowledge retrieval url must not be blank.", new Object[0]);
            EnsureUtils.ensureThat(new UrlValidator().isValid(knowledgeRetrievalUrl), "Knowledge retrieval url must be a valid URL.", new Object[0]);
            this.knowledgeRetrievalUrl = knowledgeRetrievalUrl;
        }

        @Generated
        public String getKnowledgeRetrievalUrl() {
            return this.knowledgeRetrievalUrl;
        }
    }
}

