/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.alfresco.hxi_connector.hxi_extension.rest.api.NodeEntityResource;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.PredictionModel;
import org.alfresco.hxi_connector.hxi_extension.rest.api.util.NodesUtils;
import org.alfresco.hxi_connector.hxi_extension.service.PredictionMapper;
import org.alfresco.hxi_connector.hxi_extension.service.PredictionService;
import org.alfresco.hxi_connector.hxi_extension.service.model.Prediction;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.NodesImpl;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.ListPage;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;

@RelationshipResource(name="predictions", entityResource=NodeEntityResource.class, title="Predictions for a node")
public class PredictionChildrenRelation
implements RelationshipResourceAction.Read<PredictionModel>,
RelationshipResourceAction.Create<PredictionModel> {
    private NodesImpl nodes;
    private TransactionService transactionService;
    private PredictionService predictionService;
    private PredictionMapper predictionMapper;

    public CollectionWithPagingInfo<PredictionModel> readAll(String nodeId, Parameters params) {
        NodeRef nodeRef = NodesUtils.validateOrLookupNode((Nodes)this.nodes, nodeId);
        List<Prediction> predictions = this.predictionService.getPredictions(nodeRef);
        List predictionModels = predictions.stream().map(this.predictionMapper::map).collect(Collectors.toList());
        Paging paging = params.getPaging();
        return ListPage.of(predictionModels, (Paging)paging);
    }

    public List<PredictionModel> create(String nodeId, List<PredictionModel> predictionModels, Parameters parameters) {
        NodeRef nodeRef = NodesUtils.validateOrLookupNode((Nodes)this.nodes, nodeId);
        List predictions = predictionModels.stream().map(this.predictionMapper::map).collect(Collectors.toList());
        RetryingTransactionHelper.RetryingTransactionCallback callback = () -> this.predictionService.applyPredictions(nodeRef, predictions);
        List outputPredictions = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
        return outputPredictions.stream().map(this.predictionMapper::map).collect(Collectors.toList());
    }

    @Generated
    public void setNodes(NodesImpl nodes) {
        this.nodes = nodes;
    }

    @Generated
    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Generated
    public void setPredictionService(PredictionService predictionService) {
        this.predictionService = predictionService;
    }

    @Generated
    public void setPredictionMapper(PredictionMapper predictionMapper) {
        this.predictionMapper = predictionMapper;
    }
}

