/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import java.util.List;
import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.hxi_extension.rest.api.QuestionsEntityResource;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.FeedbackModel;
import org.alfresco.hxi_connector.hxi_extension.service.HxInsightClient;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.springframework.extensions.webscripts.WebScriptException;

@RelationshipResource(name="feedback", title="Feedback about answers given to questions", entityResource=QuestionsEntityResource.class)
public class QuestionFeedbackRelation
implements RelationshipResourceAction.Create<FeedbackModel> {
    private final HxInsightClient hxInsightClient;

    public List<FeedbackModel> create(String questionId, List<FeedbackModel> feedbackEntries, Parameters parameters) {
        EnsureUtils.ensureThat(feedbackEntries.size() == 1, () -> new WebScriptException(400, "Exactly one feedback entry must be provided."));
        this.hxInsightClient.submitFeedback(questionId, feedbackEntries.get(0).toServiceModel());
        return feedbackEntries;
    }

    @Generated
    public QuestionFeedbackRelation(HxInsightClient hxInsightClient) {
        this.hxInsightClient = hxInsightClient;
    }
}

