/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.hxi_extension.rest.api.data_model.PredictionDataModel;
import org.alfresco.hxi_connector.hxi_extension.rest.api.exception.PredictionStateChangedException;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.ReviewStatus;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.UpdateType;
import org.alfresco.hxi_connector.hxi_extension.service.PredictionService;
import org.alfresco.hxi_connector.hxi_extension.service.model.Prediction;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class PredictionServiceImpl
implements PredictionService {
    private final NodeService nodeService;
    private final NamespaceService namespaceService;

    @Override
    public List<Prediction> applyPredictions(NodeRef nodeRef, List<Prediction> predictions) {
        EnsureUtils.ensureNotNullOrEmpty(predictions, "Predictions list cannot be null or empty", new Object[0]);
        HashMap<QName, Serializable> nodeProperties = new HashMap<QName, Serializable>(this.nodeService.getProperties(nodeRef));
        Map<QName, ChildAssociationRef> existingPredictedProperties = this.nodeService.getChildAssocs(nodeRef, Set.of(PredictionDataModel.TYPE_PREDICTION)).stream().collect(Collectors.toMap(ChildAssociationRef::getQName, childAssociationRef -> childAssociationRef));
        ArrayList<Prediction> returnList = new ArrayList<Prediction>();
        for (Prediction prediction : predictions) {
            QName propertyQName = QName.createQName((String)prediction.getProperty(), (NamespacePrefixResolver)this.namespaceService);
            if (existingPredictedProperties.containsKey(propertyQName)) {
                NodeRef predictionNodeRef = existingPredictedProperties.get(propertyQName).getChildRef();
                Map existingPredictionMetadata = this.nodeService.getProperties(predictionNodeRef);
                Serializable previousPredictedValue = (Serializable)existingPredictionMetadata.get(PredictionDataModel.PROP_PREDICTION_VALUE);
                if (!((Serializable)nodeProperties.get(propertyQName)).equals(previousPredictedValue)) continue;
                Serializable previousValue = (Serializable)existingPredictionMetadata.get(PredictionDataModel.PROP_PREVIOUS_VALUE);
                Map<QName, Serializable> predictionProperties = this.propertiesFromPrediction(prediction, previousValue);
                this.nodeService.setProperties(predictionNodeRef, predictionProperties);
                prediction.setId(predictionNodeRef.getId());
                prediction.setPreviousValue(previousValue);
            } else {
                Serializable previousValue = (Serializable)nodeProperties.get(propertyQName);
                Map<QName, Serializable> predictionProperties = this.propertiesFromPrediction(prediction, previousValue);
                ChildAssociationRef childAssociationRef2 = this.nodeService.createNode(nodeRef, PredictionDataModel.ASSOC_PREDICTED_BY, propertyQName, PredictionDataModel.TYPE_PREDICTION, predictionProperties);
                prediction.setId(childAssociationRef2.getChildRef().getId());
                prediction.setPreviousValue(previousValue);
            }
            returnList.add(prediction);
            nodeProperties.put(propertyQName, prediction.getPredictionValue());
        }
        if (!returnList.isEmpty()) {
            nodeProperties.put(PredictionDataModel.PROP_LATEST_PREDICTION_DATE_TIME, new Date());
            this.nodeService.setProperties(nodeRef, nodeProperties);
        }
        return returnList;
    }

    private Map<QName, Serializable> propertiesFromPrediction(Prediction prediction, Serializable previousValue) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(PredictionDataModel.PROP_PREDICTION_DATE_TIME, prediction.getPredictionDateTime());
        properties.put(PredictionDataModel.PROP_CONFIDENCE_LEVEL, Float.valueOf(prediction.getConfidenceLevel()));
        properties.put(PredictionDataModel.PROP_MODEL_ID, (Serializable)((Object)prediction.getModelId()));
        properties.put(PredictionDataModel.PROP_PREDICTION_VALUE, prediction.getPredictionValue());
        properties.put(PredictionDataModel.PROP_UPDATE_TYPE, (Serializable)((Object)prediction.getUpdateType()));
        properties.put(PredictionDataModel.PROP_PREVIOUS_VALUE, previousValue);
        properties.put(PredictionDataModel.PROP_REVIEW_STATUS, (Serializable)((Object)ReviewStatus.UNREVIEWED.toString()));
        return properties;
    }

    @Override
    public List<Prediction> getPredictions(NodeRef nodeRef) {
        List childAssocs = this.nodeService.getChildAssocs(nodeRef, Set.of(PredictionDataModel.TYPE_PREDICTION));
        return childAssocs.stream().map(this::childAssocToPrediction).collect(Collectors.toList());
    }

    private Prediction childAssocToPrediction(ChildAssociationRef childAssociationRef) {
        String property = childAssociationRef.getQName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
        NodeRef predictionNodeRef = childAssociationRef.getChildRef();
        Map properties = this.nodeService.getProperties(predictionNodeRef);
        Date predictionDateTime = (Date)properties.get(PredictionDataModel.PROP_PREDICTION_DATE_TIME);
        Float confidenceLevel = (Float)properties.get(PredictionDataModel.PROP_CONFIDENCE_LEVEL);
        String modelId = (String)properties.get(PredictionDataModel.PROP_MODEL_ID);
        Serializable predictionValue = (Serializable)properties.get(PredictionDataModel.PROP_PREDICTION_VALUE);
        Serializable previousValue = (Serializable)properties.get(PredictionDataModel.PROP_PREVIOUS_VALUE);
        UpdateType updateType = UpdateType.valueOf((String)properties.get(PredictionDataModel.PROP_UPDATE_TYPE));
        ReviewStatus reviewStatus = ReviewStatus.valueOf((String)properties.get(PredictionDataModel.PROP_REVIEW_STATUS));
        return new Prediction(predictionNodeRef.getId(), property, predictionDateTime, confidenceLevel.floatValue(), modelId, predictionValue, previousValue, updateType, reviewStatus);
    }

    @Override
    public List<String> getPredictedProperties(NodeRef nodeRef) {
        List childAssociations = this.nodeService.getChildAssocs(nodeRef, Set.of(PredictionDataModel.TYPE_PREDICTION));
        return childAssociations.stream().map(ChildAssociationRef::getQName).map(qName -> qName.toPrefixString((NamespacePrefixResolver)this.namespaceService)).collect(Collectors.toList());
    }

    @Override
    public void reviewPrediction(NodeRef predictionNodeRef, ReviewStatus reviewStatus) throws PredictionStateChangedException {
        Prediction prediction;
        QName propertyQName;
        ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(predictionNodeRef);
        NodeRef parentNode = parentAssocRef.getParentRef();
        if (!this.nodeService.getProperty(parentNode, propertyQName = QName.createQName((String)(prediction = this.childAssocToPrediction(parentAssocRef)).getProperty(), (NamespacePrefixResolver)this.namespaceService)).equals(prediction.getPredictionValue())) {
            throw new PredictionStateChangedException(prediction.getProperty() + " property value has changed, prediction is no longer valid!");
        }
        if (!ReviewStatus.UNREVIEWED.equals((Object)ReviewStatus.valueOf((String)((Object)this.nodeService.getProperty(predictionNodeRef, PredictionDataModel.PROP_REVIEW_STATUS)))) && !reviewStatus.equals((Object)prediction.getReviewStatus())) {
            throw new PredictionStateChangedException("Prediction for " + prediction.getProperty() + " property has already been reviewed.");
        }
        if (ReviewStatus.CONFIRMED.equals((Object)reviewStatus)) {
            this.nodeService.setProperty(predictionNodeRef, PredictionDataModel.PROP_REVIEW_STATUS, (Serializable)((Object)ReviewStatus.CONFIRMED.toString()));
        } else if (ReviewStatus.REJECTED.equals((Object)reviewStatus)) {
            this.nodeService.setProperty(parentNode, propertyQName, prediction.getPreviousValue());
            this.nodeService.setProperty(predictionNodeRef, PredictionDataModel.PROP_REVIEW_STATUS, (Serializable)((Object)ReviewStatus.REJECTED.toString()));
        }
    }

    @Generated
    public PredictionServiceImpl(NodeService nodeService, NamespaceService namespaceService) {
        this.nodeService = nodeService;
        this.namespaceService = namespaceService;
    }
}

