/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.messaging.repository;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;

public class AcsHealthProbe {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AcsHealthProbe.class);
    private final HttpClient client;
    private final String acsHealthEndpoint;
    private final int retryTimeoutSeconds;
    private final int retryIntervalSeconds;
    private final boolean enabled;

    @EventListener(value={ApplicationReadyEvent.class})
    public AcsHealthy runAfterStart() throws InterruptedException {
        if (this.enabled) {
            return this.checkAcsAlive();
        }
        return new AcsHealthy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AcsHealthy checkAcsAlive() throws InterruptedException {
        long currentTime;
        long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.retryTimeoutSeconds);
        do {
            try {
                log.info("Sending ACS Health Probe request to: {}", (Object)this.acsHealthEndpoint);
                HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(URI.create(this.acsHealthEndpoint)).build(), HttpResponse.BodyHandlers.ofString());
                if (AcsHealthProbe.isNotErrorCode(response.statusCode())) {
                    log.info("ACS is available at {}.", (Object)this.acsHealthEndpoint);
                    AcsHealthy acsHealthy = new AcsHealthy();
                    return acsHealthy;
                }
                this.sleep();
            }
            catch (IOException e) {
                this.sleep();
            }
            finally {
                currentTime = System.currentTimeMillis();
            }
        } while (timeout >= currentTime);
        log.error("ACS health probe failed after {} seconds. ACS is not available at {} endpoint.", (Object)this.retryTimeoutSeconds, (Object)this.acsHealthEndpoint);
        throw new EndpointServerErrorException("ACS is not available at %s".formatted(this.acsHealthEndpoint));
    }

    private void sleep() throws InterruptedException {
        log.warn("ACS is not available. Retrying in {} seconds", (Object)this.retryIntervalSeconds);
        TimeUnit.SECONDS.sleep(this.retryIntervalSeconds);
    }

    private static boolean isNotErrorCode(int statusCode) {
        return statusCode >= 100 && statusCode < 400;
    }

    @Generated
    public AcsHealthProbe(HttpClient client, String acsHealthEndpoint, int retryTimeoutSeconds, int retryIntervalSeconds, boolean enabled) {
        this.client = client;
        this.acsHealthEndpoint = acsHealthEndpoint;
        this.retryTimeoutSeconds = retryTimeoutSeconds;
        this.retryIntervalSeconds = retryIntervalSeconds;
        this.enabled = enabled;
    }

    public static class AcsHealthy {
    }
}

