/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import java.util.List;
import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.hxi_extension.rest.api.AgentsEntityResource;
import org.alfresco.hxi_connector.hxi_extension.rest.api.config.QuestionsApiConfig;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.QuestionModel;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.RetryModel;
import org.alfresco.hxi_connector.hxi_extension.service.QuestionPermissionService;
import org.alfresco.hxi_connector.hxi_extension.service.QuestionService;
import org.alfresco.hxi_connector.hxi_extension.service.model.Question;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.WebScriptException;

@RelationshipResource(name="questions", title="Questions about documents", entityResource=AgentsEntityResource.class)
public class AgentsQuestionsRelation
implements RelationshipResourceAction.Create<QuestionModel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentsQuestionsRelation.class);
    private final QuestionService questionService;
    private final QuestionsApiConfig questionConfig;
    private final QuestionPermissionService questionPermissionService;

    @WebApiDescription(title="Ask question", successStatus=200)
    public List<QuestionModel> create(String agentId, List<QuestionModel> questions, Parameters parameters) {
        EnsureUtils.ensureThat(questions.size() == 1, () -> new WebScriptException(400, "You can only ask one question at a time."));
        QuestionModel questionModel = questions.get(0);
        Question question = this.validateQuestion(questionModel);
        String questionId = this.questionService.askQuestion(agentId, question);
        return List.of(questionModel.withId(questionId));
    }

    @Operation(value="retry")
    @WebApiDescription(title="Retry question", description="Resubmit a question to try to get a better answer.")
    public RetryModel retry(String agentId, String questionId, RetryModel retry, Parameters parameters, WithResponse withResponse) {
        Question question = this.validateQuestion(retry.getOriginalQuestion());
        String newQuestionId = this.questionService.retryQuestion(agentId, questionId, retry.getComments(), question);
        return retry.withId(newQuestionId);
    }

    private Question validateQuestion(QuestionModel questionModel) {
        Question question = questionModel.toQuestion();
        log.info("Received question: {}", (Object)question);
        EnsureUtils.ensureThat(questionModel.getRestrictionQuery().getNodesIds().size() <= this.questionConfig.getMaxContextSizeForQuestion(), () -> new WebScriptException(400, String.format("You can only ask about up to %d nodes at a time.", this.questionConfig.getMaxContextSizeForQuestion())));
        EnsureUtils.ensureThat(this.questionPermissionService.hasPermissionToAskAboutDocuments(question), () -> new WebScriptException(403, "You don't have permission to ask about some nodes"));
        return question;
    }

    @Generated
    public AgentsQuestionsRelation(QuestionService questionService, QuestionsApiConfig questionConfig, QuestionPermissionService questionPermissionService) {
        this.questionService = questionService;
        this.questionConfig = questionConfig;
        this.questionPermissionService = questionPermissionService;
    }
}

