/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.alfresco.hxi_connector.hxi_extension.rest.api.data_model.PredictionDataModel;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.NodeWithPrediction;
import org.alfresco.hxi_connector.hxi_extension.rest.api.util.NodesUtils;
import org.alfresco.hxi_connector.hxi_extension.service.PredictionService;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.NodesImpl;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

@EntityResource(name="nodes", title="Nodes With Predictions")
public class NodeEntityResource
implements EntityResourceAction.ReadById<NodeWithPrediction> {
    private NodeService nodeService;
    private NodesImpl nodes;
    private PredictionService predictionService;

    public NodeWithPrediction readById(String id, Parameters parameters) throws EntityNotFoundException {
        NodeRef nodeRef = NodesUtils.validateOrLookupNode((Nodes)this.nodes, id);
        Date date = (Date)this.nodeService.getProperty(nodeRef, PredictionDataModel.PROP_LATEST_PREDICTION_DATE_TIME);
        List<String> predictedProperties = this.predictionService.getPredictedProperties(nodeRef);
        return new NodeWithPrediction(id, date, predictedProperties);
    }

    @Generated
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Generated
    public void setNodes(NodesImpl nodes) {
        this.nodes = nodes;
    }

    @Generated
    public void setPredictionService(PredictionService predictionService) {
        this.predictionService = predictionService;
    }
}

