/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.repository.filter;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.alfresco.database.connector.model.AlfrescoNode;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.NamespacePrefixMapper;
import org.alfresco.hxi_connector.bulk_ingester.repository.filter.AlfrescoNodeFilterApplier;
import org.alfresco.hxi_connector.bulk_ingester.repository.filter.NodeFilterConfig;
import org.alfresco.hxi_connector.common.repository.filter.CollectionFilter;
import org.apache.commons.collections4.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AspectFilterApplier
implements AlfrescoNodeFilterApplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AspectFilterApplier.class);
    private final NamespacePrefixMapper predefinedNamespacePrefixMapper;

    public boolean applyFilter(AlfrescoNode alfrescoNode, NodeFilterConfig filterConfig) {
        Set nodeAspects = SetUtils.emptyIfNull((Set)alfrescoNode.getAspects());
        Set aspectNames = SetUtils.emptyIfNull(nodeAspects.stream().map(arg_0 -> ((NamespacePrefixMapper)this.predefinedNamespacePrefixMapper).toPrefixedName(arg_0)).collect(Collectors.toSet()));
        List allowed = filterConfig.aspect().allow();
        List denied = filterConfig.aspect().deny();
        log.atDebug().log("Applying aspect filters on Alfresco node of id: {}", (Object)alfrescoNode.getId());
        return CollectionFilter.filter((Collection)aspectNames, (Collection)allowed, (Collection)denied);
    }

    @Generated
    public AspectFilterApplier(NamespacePrefixMapper predefinedNamespacePrefixMapper) {
        this.predefinedNamespacePrefixMapper = predefinedNamespacePrefixMapper;
    }
}

