/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.bulk_ingester.repository.filter;

import java.util.List;
import lombok.Generated;
import org.alfresco.database.connector.model.AlfrescoNode;
import org.alfresco.hxi_connector.bulk_ingester.processor.mapper.NamespacePrefixMapper;
import org.alfresco.hxi_connector.bulk_ingester.repository.filter.AlfrescoNodeFilterApplier;
import org.alfresco.hxi_connector.bulk_ingester.repository.filter.NodeFilterConfig;
import org.alfresco.hxi_connector.common.repository.filter.FieldFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TypeFilterApplier
implements AlfrescoNodeFilterApplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TypeFilterApplier.class);
    private final NamespacePrefixMapper predefinedNamespacePrefixMapper;

    public boolean applyFilter(AlfrescoNode alfrescoNode, NodeFilterConfig filterConfig) {
        String nodeType = this.predefinedNamespacePrefixMapper.toPrefixedName(alfrescoNode.getType());
        List allowed = filterConfig.type().allow();
        List denied = filterConfig.type().deny();
        log.atDebug().log("Applying type filters on Alfresco node of id: {}", (Object)alfrescoNode.getId());
        return FieldFilter.filter((String)nodeType, (List)allowed, (List)denied);
    }

    @Generated
    public TypeFilterApplier(NamespacePrefixMapper predefinedNamespacePrefixMapper) {
        this.predefinedNamespacePrefixMapper = predefinedNamespacePrefixMapper;
    }
}

