/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.repository.filter;

import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CollectionFilter.class);

    public static boolean filter(Collection<String> fields, Collection<String> allowed, Collection<String> denied) {
        boolean allow = CollectionFilter.isAllowed(fields, allowed);
        boolean deny = CollectionFilter.isDenied(fields, denied);
        boolean result = allow && !deny;
        log.atDebug().log("Filtering :: Node fields collection: {}. Allowed values: {}. Denied values: {}. Is allowed: {}", new Object[]{fields, allowed, denied, result});
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAllowed(@NotNull Collection<String> fields, @NotNull Collection<String> allowed) {
        if (allowed.isEmpty()) return true;
        if (!allowed.stream().anyMatch(fields::contains)) return false;
        return true;
    }

    private static boolean isDenied(@NotNull Collection<String> fields, @NotNull Collection<String> denied) {
        return denied.stream().anyMatch(fields::contains);
    }

    @Generated
    private CollectionFilter() {
    }
}

