/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension;

import org.alfresco.hxi_connector.common.test.docker.repository.AlfrescoRepositoryContainer;
import org.alfresco.hxi_connector.common.test.docker.util.DockerContainers;
import org.alfresco.hxi_connector.hxi_extension.rest.api.ConfigEntityResource;
import org.alfresco.hxi_connector.hxi_extension.util.client.TestRepoClient;
import org.alfresco.rest.api.model.Aspect;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class PredictionApplierExtensionIntegrationTest {
    private static final String EXPECTED_HXI_ASPECT = "hxi:predictionApplied";
    static final Network network = Network.newNetwork();
    @Container
    static final PostgreSQLContainer<?> postgres = DockerContainers.createPostgresContainerWithin((Network)network);
    @Container
    static final GenericContainer<?> activemq = DockerContainers.createActiveMqContainerWithin((Network)network);
    @Container
    static final AlfrescoRepositoryContainer repository = PredictionApplierExtensionIntegrationTest.createRepositoryContainer();
    TestRepoClient testRepoClient = new TestRepoClient(repository.getHost(), repository.getPort());

    @Test
    void testHxIModelInstallation() {
        Aspect actualAspect = this.testRepoClient.getAspectById(EXPECTED_HXI_ASPECT);
        Assertions.assertThat((Comparable)actualAspect).isNotNull();
    }

    @Test
    void testConfigUrl() {
        ConfigEntityResource.HxIConfig config = this.testRepoClient.getConfig();
        Assertions.assertThat((String)config.getKnowledgeRetrievalUrl()).isEqualTo("http://dummy-host.xyz/knowledge-retrieval/bots");
    }

    private static AlfrescoRepositoryContainer createRepositoryContainer() {
        return (AlfrescoRepositoryContainer)DockerContainers.createExtendedRepositoryContainerWithin((Network)network).withEnv("JAVA_OPTS", "-Ddb.driver=org.postgresql.Driver\n-Ddb.username=%s\n-Ddb.password=%s\n-Ddb.url=jdbc:postgresql://%s:5432/%s\n-Dmessaging.broker.url=\"failover:(nio://%s:61616)?timeout=3000&jms.useCompression=true\"\n-Dalfresco.host=localhost\n-Dalfresco.port=8080\n-Dtransform.service.enabled=false\n-Dalfresco.restApi.basicAuthScheme=true\n-Ddeployment.method=DOCKER_COMPOSE\n-Xms1500m -Xmx1500m\n".formatted(postgres.getUsername(), postgres.getPassword(), postgres.getNetworkAliases().stream().findFirst().get(), postgres.getDatabaseName(), activemq.getNetworkAliases().stream().findFirst().get()).replace("\n", " "));
    }
}

