/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import java.util.Collections;
import org.alfresco.hxi_connector.hxi_extension.rest.api.QuestionAnswersRelation;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.AnswerModel;
import org.alfresco.hxi_connector.hxi_extension.service.QuestionService;
import org.alfresco.hxi_connector.hxi_extension.service.model.AnswerResponse;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.extensions.webscripts.WebScriptException;

@ExtendWith(value={MockitoExtension.class})
class QuestionAnswersRelationTest {
    private static final String DEFAULT_ID = "-default-";
    @Mock
    private QuestionService questionService;
    @Mock
    private Parameters mockParameters;
    @InjectMocks
    private QuestionAnswersRelation objectUnderTest;

    QuestionAnswersRelationTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"COMPLETE,true", "INCOMPLETE,false", "SUBMITTED,false"})
    void shouldCallHxInsightClientGetAnswer(String responseCompleteness, boolean isComplete) {
        String question = "Some question";
        AnswerResponse hXAnswer = AnswerResponse.builder().question(question).responseCompleteness(responseCompleteness).answer("Some answer").build();
        String questionId = "questionId";
        BDDMockito.given((Object)this.questionService.getAnswer(questionId)).willReturn((Object)hXAnswer);
        AnswerModel answerResponse = this.objectUnderTest.readById(questionId, DEFAULT_ID, this.mockParameters);
        ((QuestionService)BDDMockito.then((Object)this.questionService).should()).getAnswer(questionId);
        AnswerModel expectedAnswer = new AnswerModel(hXAnswer.getAnswer(), hXAnswer.getQuestion(), isComplete, Collections.emptySet());
        Assertions.assertEquals((Object)expectedAnswer, (Object)answerResponse);
    }

    @Test
    void shouldFailIfIdIsNotDefault() {
        String questionId = "questionId";
        Assertions.assertThrows(EntityNotFoundException.class, () -> this.objectUnderTest.readById(questionId, "random-id", this.mockParameters));
    }

    @Test
    void shouldFailWhenHxClientThrowsException() {
        String questionId = "questionId";
        BDDMockito.given((Object)this.questionService.getAnswer(questionId)).willThrow(new Throwable[]{new WebScriptException(503, "Some error message")});
        Assertions.assertThrows(WebScriptException.class, () -> this.objectUnderTest.readById(questionId, DEFAULT_ID, this.mockParameters));
    }
}

