/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth;

import java.util.AbstractMap;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AccessTokenProvider;
import org.alfresco.hxi_connector.common.adapters.auth.config.properties.AuthProperties;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);
    public static final String HXP_ENVIRONMENT_HEADER = "Hxp-Environment";
    public static final String HXP_APP_HEADER = "Hxp-App";
    private static final String HXP_APP_VALUE = "hxai-discovery";
    public static final String HXP_AUTH_PROVIDER = "hyland-experience";
    public static final String ALFRESCO_AUTH_PROVIDER = "alfresco";
    static final String BASIC = "Basic ";
    static final String BEARER = "Bearer ";
    private final AuthProperties authProperties;
    private final AccessTokenProvider accessTokenProvider;

    public void setAlfrescoAuthorizationHeaders(Exchange exchange) {
        String authType = this.authProperties.getProviders().get(ALFRESCO_AUTH_PROVIDER).getType();
        this.clearAuthHeaders(exchange);
        this.getAlfrescoAuthHeaders().forEach((key, value) -> exchange.getIn().setHeader(key, value));
        log.debug("Authorization :: {} {} authorization header added", (Object)ALFRESCO_AUTH_PROVIDER, (Object)authType);
    }

    public void setHxIAuthorizationHeaders(Exchange exchange) {
        this.clearAuthHeaders(exchange);
        this.getHxpAuthHeaders().forEach((key, value) -> exchange.getIn().setHeader(key, value));
        log.debug("Authorization :: {} authorization header added", (Object)HXP_AUTH_PROVIDER);
    }

    public Map<String, String> getHxpAuthHeaders() {
        return Stream.of(this.getAuthHeader(HXP_AUTH_PROVIDER), this.getHxpEnvironmentHeader(), this.getHxpAppHeader()).filter(entry -> Objects.nonNull(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, String> getAlfrescoAuthHeaders() {
        return Map.ofEntries(this.getAuthHeader(ALFRESCO_AUTH_PROVIDER));
    }

    public Map.Entry<String, String> getAuthHeader(String providerId) {
        return Map.entry("Authorization", this.getAuthHeaderValue(providerId));
    }

    protected Map.Entry<String, String> getHxpEnvironmentHeader() {
        return new AbstractMap.SimpleEntry<String, String>(HXP_ENVIRONMENT_HEADER, Optional.ofNullable(this.authProperties.getProviders().get(HXP_AUTH_PROVIDER)).map(AuthProperties.AuthProvider::getEnvironmentKey).orElse(null));
    }

    protected Map.Entry<String, String> getHxpAppHeader() {
        return Map.entry(HXP_APP_HEADER, HXP_APP_VALUE);
    }

    private String getAuthHeaderValue(String providerId) {
        AuthProperties.AuthProvider authProvider = this.authProperties.getProviders().get(ALFRESCO_AUTH_PROVIDER);
        return providerId.equals(HXP_AUTH_PROVIDER) ? this.getBearerAuthHeader(HXP_AUTH_PROVIDER) : this.getAlfrescoAuthHeader(authProvider);
    }

    private String getAlfrescoAuthHeader(AuthProperties.AuthProvider authProvider) {
        if (BASIC.trim().equalsIgnoreCase(authProvider.getType())) {
            return BASIC + AuthService.getBasicAuthHeader(authProvider);
        }
        return this.getBearerAuthHeader(ALFRESCO_AUTH_PROVIDER);
    }

    private String getBearerAuthHeader(String providerId) {
        return BEARER + this.accessTokenProvider.getAccessToken(providerId);
    }

    private void clearAuthHeaders(Exchange exchange) {
        exchange.getIn().removeHeader("Authorization");
        exchange.getIn().removeHeader(this.getHxpEnvironmentHeader().getKey());
        exchange.getIn().removeHeader(this.getHxpAppHeader().getKey());
    }

    private static String getBasicAuthHeader(AuthProperties.AuthProvider authProvider) {
        String valueToEncode = authProvider.getUsername() + ":" + authProvider.getPassword();
        return Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    @Generated
    public AuthService(AuthProperties authProperties, AccessTokenProvider accessTokenProvider) {
        this.authProperties = authProperties;
        this.accessTokenProvider = accessTokenProvider;
    }
}

