/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Positive;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthenticationResult {
    @NotBlank
    @JsonProperty(value="access_token")
    String accessToken;
    @Positive
    @JsonProperty(value="expires_in")
    int expiresIn;
    TemporalUnit temporalUnit = ChronoUnit.SECONDS;
    @NotBlank
    @JsonProperty(value="token_type")
    String tokenType;
    @NotBlank
    String scope;
    Integer statusCode = 200;

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public int getExpiresIn() {
        return this.expiresIn;
    }

    @Generated
    public TemporalUnit getTemporalUnit() {
        return this.temporalUnit;
    }

    @Generated
    public String getTokenType() {
        return this.tokenType;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }

    @Generated
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Generated
    public void setTemporalUnit(TemporalUnit temporalUnit) {
        this.temporalUnit = temporalUnit;
    }

    @Generated
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Generated
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Generated
    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationResult)) {
            return false;
        }
        AuthenticationResult other = (AuthenticationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiresIn() != other.getExpiresIn()) {
            return false;
        }
        Integer this$statusCode = this.getStatusCode();
        Integer other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        TemporalUnit this$temporalUnit = this.getTemporalUnit();
        TemporalUnit other$temporalUnit = other.getTemporalUnit();
        if (this$temporalUnit == null ? other$temporalUnit != null : !this$temporalUnit.equals(other$temporalUnit)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExpiresIn();
        Integer $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        TemporalUnit $temporalUnit = this.getTemporalUnit();
        result = result * 59 + ($temporalUnit == null ? 43 : $temporalUnit.hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticationResult(accessToken=" + this.getAccessToken() + ", expiresIn=" + this.getExpiresIn() + ", temporalUnit=" + String.valueOf(this.getTemporalUnit()) + ", tokenType=" + this.getTokenType() + ", scope=" + this.getScope() + ", statusCode=" + this.getStatusCode() + ")";
    }

    @Generated
    public AuthenticationResult() {
    }

    @Generated
    public AuthenticationResult(String accessToken, int expiresIn, TemporalUnit temporalUnit, String tokenType, String scope, Integer statusCode) {
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.temporalUnit = temporalUnit;
        this.tokenType = tokenType;
        this.scope = scope;
        this.statusCode = statusCode;
    }
}

