/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import lombok.Generated;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.ReviewStatus;
import org.alfresco.hxi_connector.hxi_extension.rest.api.util.NodesUtils;
import org.alfresco.hxi_connector.hxi_extension.service.PredictionService;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.NodesImpl;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.NodeRef;

@EntityResource(name="predictions", title="Predictions")
public class PredictionsEntityResource {
    private static final String PARAM_REVIEW_STATUS = "reviewStatus";
    private NodesImpl nodes;
    private PredictionService predictionService;

    @Operation(value="review")
    @WebApiDescription(title="Review prediction")
    public void reviewPrediction(String predictionNodeId, Void body, Parameters parameters, WithResponse withResponse) {
        NodeRef predictionNodeRef = NodesUtils.validateOrLookupNode((Nodes)this.nodes, predictionNodeId);
        ReviewStatus reviewStatus = ReviewStatus.valueOf(parameters.getParameter(PARAM_REVIEW_STATUS).toUpperCase());
        this.predictionService.reviewPrediction(predictionNodeRef, reviewStatus);
    }

    @Generated
    public void setNodes(NodesImpl nodes) {
        this.nodes = nodes;
    }

    @Generated
    public void setPredictionService(PredictionService predictionService) {
        this.predictionService = predictionService;
    }
}

