/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.transform.response;

import lombok.Generated;
import org.alfresco.hxi_connector.common.exception.ResourceNotFoundException;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.transform.request.ATSTransformRequester;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.transform.response.TransformResponse;
import org.alfresco.hxi_connector.live_ingester.domain.ports.transform_engine.TransformRequest;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.IngestContentCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.IngestContentCommandHandler;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.model.EmptyRenditionException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ATSTransformResponseHandler
extends RouteBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ATSTransformResponseHandler.class);
    private static final String ROUTE_ID = "transform-events-consumer";
    private static final int EXPECTED_STATUS_CODE = 201;
    static final String EXPECTED_STATUS_CODE_REGEX = "[\\s\\S]*\"status\"\\s*:\\s*%s[^0-9][\\s\\S]*".formatted(201);
    private final IngestContentCommandHandler ingestContentCommandHandler;
    private final IntegrationProperties integrationProperties;
    private final ATSTransformRequester atsTransformRequester;

    public void configure() {
        String transformationSource = this.integrationProperties.alfresco().transform().response().endpoint();
        ((OnExceptionDefinition)this.onException(new Class[]{EmptyRenditionException.class, ResourceNotFoundException.class}).log(LoggingLevel.WARN, log, "Transform :: Unexpected state while processing rendition from: %s due to: ${exception.message}. Body: ${body}".formatted(transformationSource))).process(arg_0 -> this.retryContentTransformation(arg_0));
        ((OnExceptionDefinition)this.onException(Exception.class).log(LoggingLevel.ERROR, log, "Transform :: Retrying ${routeId}, attempt ${header.CamelRedeliveryCounter} due to ${exception.message}. Body: ${body}")).maximumRedeliveries(this.integrationProperties.alfresco().transform().response().retryIngestion().attempts()).redeliveryDelay((long)this.integrationProperties.alfresco().transform().response().retryIngestion().initialDelay()).backOffMultiplier(this.integrationProperties.alfresco().transform().response().retryIngestion().delayMultiplier());
        ((ChoiceDefinition)((ChoiceDefinition)this.from(transformationSource).routeId(ROUTE_ID).choice().when(this.body().regex(EXPECTED_STATUS_CODE_REGEX)).log(LoggingLevel.DEBUG, log, "Transform :: Received transform completed event: ${body}")).otherwise().log(LoggingLevel.WARN, log, "Transform :: Transformation failed. Body: ${body}")).end().unmarshal().json(JsonLibrary.Jackson, TransformResponse.class).process(arg_0 -> this.ingestContent(arg_0)).end();
    }

    private void ingestContent(Exchange exchange) {
        TransformResponse transformResponse = (TransformResponse)exchange.getIn().getBody(TransformResponse.class);
        if (transformResponse.status() == 400) {
            return;
        }
        IngestContentCommand command = new IngestContentCommand(transformResponse.targetReference(), transformResponse.clientData().nodeRef(), transformResponse.clientData().targetMimeType(), transformResponse.clientData().timestamp());
        this.ingestContentCommandHandler.handle(command);
    }

    private void retryContentTransformation(Exchange exchange) {
        Exception exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        TransformResponse transformResponse = (TransformResponse)exchange.getIn().getBody(TransformResponse.class);
        int maxAttempts = this.integrationProperties.alfresco().transform().response().retryTransformation().attempts();
        int retryAttempt = transformResponse.clientData().retryAttempt() + 1;
        if (retryAttempt > maxAttempts) {
            log.error("Transform :: Transformation of node {} failed with error {}, max number of retries ({}) exceeded", new Object[]{transformResponse.clientData().nodeRef(), exception.getMessage(), maxAttempts});
            return;
        }
        log.info("Transform :: Transformation of node {} failed with error {}, retrying (attempt: {})", new Object[]{transformResponse.clientData().nodeRef(), exception.getMessage(), retryAttempt});
        TransformRequest transformRequest = new TransformRequest(transformResponse.clientData().nodeRef(), transformResponse.clientData().targetMimeType(), transformResponse.clientData().timestamp());
        this.atsTransformRequester.requestTransformRetry(transformRequest, retryAttempt);
    }

    @Generated
    public ATSTransformResponseHandler(IngestContentCommandHandler ingestContentCommandHandler, IntegrationProperties integrationProperties, ATSTransformRequester atsTransformRequester) {
        this.ingestContentCommandHandler = ingestContentCommandHandler;
        this.integrationProperties = integrationProperties;
        this.atsTransformRequester = atsTransformRequester;
    }
}

