/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.AuthorityInfo;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.PermissionsProperty;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.UpdateNodeEvent;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.property.PropertyResolver;

public class PermissionsMetadataUpdated
extends PropertyDelta<List<AuthorityInfo>> {
    private final List<AuthorityInfo> allowAccess;
    private final List<AuthorityInfo> denyAccess;

    public PermissionsMetadataUpdated(String propertyName, List<AuthorityInfo> allowAccess, List<AuthorityInfo> denyAccess) {
        super(propertyName);
        this.allowAccess = allowAccess;
        this.denyAccess = denyAccess;
    }

    public List<AuthorityInfo> getAllowAccess() {
        return this.allowAccess;
    }

    public List<AuthorityInfo> getDenyAccess() {
        return this.denyAccess;
    }

    @Override
    public void applyOn(UpdateNodeEvent event) {
        event.addPermissionsInstruction(new PermissionsProperty(this.getPropertyName(), this.allowAccess, this.denyAccess));
    }

    @Override
    public <R> Optional<PropertyDelta<R>> resolveWith(PropertyResolver<R> resolver) {
        return Optional.empty();
    }

    public static PermissionsMetadataUpdatedBuilder builder(String propertyName) {
        return new PermissionsMetadataUpdatedBuilder(propertyName);
    }

    @Override
    @Generated
    public String toString() {
        return "PermissionsMetadataUpdated(super=" + super.toString() + ", allowAccess=" + String.valueOf(this.getAllowAccess()) + ", denyAccess=" + String.valueOf(this.getDenyAccess()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PermissionsMetadataUpdated)) {
            return false;
        }
        PermissionsMetadataUpdated other = (PermissionsMetadataUpdated)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<AuthorityInfo> this$allowAccess = this.getAllowAccess();
        List<AuthorityInfo> other$allowAccess = other.getAllowAccess();
        if (this$allowAccess == null ? other$allowAccess != null : !((Object)this$allowAccess).equals(other$allowAccess)) {
            return false;
        }
        List<AuthorityInfo> this$denyAccess = this.getDenyAccess();
        List<AuthorityInfo> other$denyAccess = other.getDenyAccess();
        return !(this$denyAccess == null ? other$denyAccess != null : !((Object)this$denyAccess).equals(other$denyAccess));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PermissionsMetadataUpdated;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<AuthorityInfo> $allowAccess = this.getAllowAccess();
        result = result * 59 + ($allowAccess == null ? 43 : ((Object)$allowAccess).hashCode());
        List<AuthorityInfo> $denyAccess = this.getDenyAccess();
        result = result * 59 + ($denyAccess == null ? 43 : ((Object)$denyAccess).hashCode());
        return result;
    }

    public static class PermissionsMetadataUpdatedBuilder {
        private final String propertyName;
        private List<AuthorityInfo> allowAccess;
        private List<AuthorityInfo> denyAccess;

        public PermissionsMetadataUpdatedBuilder(String propertyName) {
            this.propertyName = propertyName;
        }

        public PermissionsMetadataUpdatedBuilder read(List<AuthorityInfo> allowAccess) {
            this.allowAccess = allowAccess;
            return this;
        }

        public PermissionsMetadataUpdatedBuilder deny(List<AuthorityInfo> denyAccess) {
            this.denyAccess = denyAccess;
            return this;
        }

        public PermissionsMetadataUpdated build() {
            return new PermissionsMetadataUpdated(this.propertyName, this.allowAccess, this.denyAccess);
        }
    }
}

