/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.config.messaging;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.jms.ConnectionFactory;
import java.net.http.HttpClient;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.AcsHealthProbe;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.ApplicationInfoProvider;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.DiscoveryApiRepositoryInformation;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.ProcessingStarter;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.RepositoryInformation;
import org.alfresco.hxi_connector.common.config.properties.Application;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.PropertyBasedRepositoryInformation;
import org.apache.camel.CamelContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class LiveIngesterMessagingConfig {
    public static final String CONFIGURATION_ERR_MESSAGE = "One of properties: 'alfresco.repository.discovery-endpoint' or 'alfresco.repository.version-override' must be set in the Live Ingester configuration.";

    @Bean
    public PlatformTransactionManager jmsTransactionManager(ConnectionFactory connectionFactory) {
        return new JmsTransactionManager(connectionFactory);
    }

    @Bean
    @ConfigurationProperties(prefix="application")
    public Application application() {
        return new Application();
    }

    @Bean
    public HttpClient httpClient() {
        return HttpClient.newHttpClient();
    }

    @Bean
    public AcsHealthProbe acsHealthProbe(HttpClient httpClient, IntegrationProperties integrationProperties) {
        boolean isVersionOverrideBlank = StringUtils.isBlank((CharSequence)integrationProperties.alfresco().repository().versionOverride());
        boolean isDiscoverEndpointBlank = StringUtils.isBlank((CharSequence)integrationProperties.alfresco().repository().discoveryEndpoint());
        if (isVersionOverrideBlank && isDiscoverEndpointBlank) {
            throw new IllegalStateException(CONFIGURATION_ERR_MESSAGE);
        }
        return new AcsHealthProbe(httpClient, integrationProperties.alfresco().repository().healthProbe().endpoint(), integrationProperties.alfresco().repository().healthProbe().timeoutSeconds(), integrationProperties.alfresco().repository().healthProbe().intervalSeconds(), isVersionOverrideBlank);
    }

    @Bean
    public RepositoryInformation repositoryInformation(AuthService authService, ObjectMapper objectMapper, IntegrationProperties integrationProperties, HttpClient httpClient) {
        if (StringUtils.isNotBlank((CharSequence)integrationProperties.alfresco().repository().versionOverride())) {
            return new PropertyBasedRepositoryInformation(integrationProperties);
        }
        if (StringUtils.isNotBlank((CharSequence)integrationProperties.alfresco().repository().discoveryEndpoint())) {
            return new DiscoveryApiRepositoryInformation(integrationProperties.alfresco().repository().discoveryEndpoint(), authService, objectMapper, httpClient);
        }
        throw new IllegalStateException(CONFIGURATION_ERR_MESSAGE);
    }

    @Bean
    public ApplicationInfoProvider applicationInfoProvider(RepositoryInformation repositoryInformation, IntegrationProperties integrationProperties) {
        return new ApplicationInfoProvider(repositoryInformation, integrationProperties.application());
    }

    @Bean
    public ProcessingStarter processingStarter(CamelContext camelContext) {
        return new ProcessingStarter(camelContext);
    }
}

