/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository;

import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.EventProcessor;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.CamelEventMapper;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.util.LoggingUtils;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class LiveIngesterEventHandler
extends RouteBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiveIngesterEventHandler.class);
    private static final String ROUTE_ID = "repo-events-consumer";
    private final EventProcessor eventProcessor;
    private final IntegrationProperties integrationProperties;
    private final CamelEventMapper camelEventMapper;

    public void configure() {
        String eventSource = this.integrationProperties.alfresco().repository().eventsEndpoint();
        ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).log(LoggingLevel.ERROR, log, "Repository :: Unexpected state while processing event from: %s".formatted(eventSource))).process(exchange -> LoggingUtils.logMaskedExchangeState((Exchange)exchange, (Logger)log, (Level)Level.ERROR))).stop();
        SecurityContext securityContext = SecurityContextHolder.getContext();
        ((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)this.from(eventSource).transacted().routeId(ROUTE_ID)).log(LoggingLevel.DEBUG, log, "Repository :: Received event: ${body}")).setBody(arg_0 -> ((CamelEventMapper)this.camelEventMapper).repoEventFrom(arg_0))).log(LoggingLevel.INFO, log, "Repository :: Received event with ID: ${body.id} and type: ${body.type} for node: ${body.data?.resource?.id}")).process(exchange -> SecurityContextHolder.setContext((SecurityContext)securityContext))).process(arg_0 -> ((EventProcessor)this.eventProcessor).process(arg_0))).end();
    }

    @Generated
    public LiveIngesterEventHandler(EventProcessor eventProcessor, IntegrationProperties integrationProperties, CamelEventMapper camelEventMapper) {
        this.eventProcessor = eventProcessor;
        this.integrationProperties = integrationProperties;
        this.camelEventMapper = camelEventMapper;
    }
}

