/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class LoggingUtils {
    private static final String MASK = "***";
    private static final Set<String> HEADERS_TO_MASK = Set.of("Authorization");

    public static void logMaskedExchangeState(Exchange exchange, Logger log, Level level) {
        Map properties = exchange.getProperties();
        Map<String, Object> headers = new HashMap(exchange.getMessage().getHeaders()).entrySet().stream().peek(e -> {
            if (HEADERS_TO_MASK.contains(e.getKey())) {
                e.setValue(MASK);
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String bodyType = exchange.getMessage().getBody() != null ? exchange.getMessage().getBody().getClass().getName() : "";
        String body = (String)exchange.getMessage().getBody(String.class);
        log.atLevel(level).log("Exchange: [\n\tProperties: {}\n\tHeaders: {}\n\tBodyType: {}\n\tBody: {}\n]", new Object[]{properties, headers, bodyType, body});
    }

    @Generated
    private LoggingUtils() {
    }
}

