/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.domain.exception.LiveIngesterRuntimeException;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CamelEventMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CamelEventMapper.class);
    private final ObjectMapper mapper;

    public RepoEvent<DataAttributes<NodeResource>> repoEventFrom(Exchange exchange) {
        try {
            return (RepoEvent)this.mapper.readValue((String)exchange.getIn().getBody(String.class), (TypeReference)new TypeReference<RepoEvent<DataAttributes<NodeResource>>>(){});
        }
        catch (JsonProcessingException e) {
            throw new LiveIngesterRuntimeException("Event deserialization failed", e);
        }
    }

    public RepoEvent<DataAttributes<NodeResource>> alterRepoEvent(Exchange exchange, String newEventType) {
        RepoEvent repoEventOriginal = (RepoEvent)exchange.getIn().getBody(RepoEvent.class);
        log.atDebug().log("Altering repo event type from {} to {}. Repo Event id: {}", new Object[]{repoEventOriginal.getType(), newEventType, repoEventOriginal.getId()});
        return RepoEvent.builder().setData(repoEventOriginal.getData()).setDatacontenttype(repoEventOriginal.getDatacontenttype()).setDataschema(repoEventOriginal.getDataschema()).setExtensionAttributes(repoEventOriginal.getExtensionAttributes()).setId(repoEventOriginal.getId()).setSource(repoEventOriginal.getSource()).setTime(repoEventOriginal.getTime()).setType(newEventType).build();
    }

    @Generated
    public CamelEventMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

