/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.config.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.util.Locale;
import org.alfresco.hxi_connector.live_ingester.adapters.config.jackson.exception.JsonSerializationException;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.DeleteNodeEvent;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.EventType;
import org.springframework.stereotype.Component;

@Component
public class DeleteNodeEventSerializer
extends StdSerializer<DeleteNodeEvent> {
    public DeleteNodeEventSerializer() {
        this(null);
    }

    public DeleteNodeEventSerializer(Class<DeleteNodeEvent> t) {
        super(t);
    }

    public void serialize(DeleteNodeEvent event, JsonGenerator jgen, SerializerProvider provider) {
        try {
            jgen.writeStartArray();
            jgen.writeStartObject();
            jgen.writeStringField("objectId", event.getObjectId());
            jgen.writeStringField("sourceId", event.getSourceId());
            jgen.writeNumberField("sourceTimestamp", event.getTimestamp());
            jgen.writeStringField("eventType", this.serializeEventType(event.getEventType()));
            jgen.writeEndObject();
            jgen.writeEndArray();
        }
        catch (Exception e) {
            throw new JsonSerializationException("Property serialization failed", (Throwable)e);
        }
    }

    private String serializeEventType(EventType eventType) {
        return eventType.toString().toLowerCase(Locale.ENGLISH);
    }
}

