/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.bulk_ingester;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import org.alfresco.hxi_connector.common.model.ingest.IngestEvent;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.bulk_ingester.IngestEventProcessor;
import org.alfresco.hxi_connector.live_ingester.domain.exception.LiveIngesterRuntimeException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.TransactedDefinition;
import org.springframework.stereotype.Component;

@Component
public class IngestEventListener
extends RouteBuilder {
    private static final String ROUTE_ID = "bulk-ingester-events-consumer";
    private final ObjectMapper objectMapper;
    private final IngestEventProcessor eventProcessor;
    private final IntegrationProperties integrationProperties;

    public void configure() {
        ((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)this.from(this.integrationProperties.alfresco().bulkIngester().endpoint()).transacted().routeId(ROUTE_ID)).log(LoggingLevel.DEBUG, "Received bulk ingester event : ${header.JMSMessageID}")).process(exchange -> this.eventProcessor.process(this.mapToIngestEvent(exchange)))).end();
    }

    private IngestEvent mapToIngestEvent(Exchange exchange) {
        try {
            return (IngestEvent)this.objectMapper.readValue((String)exchange.getIn().getBody(String.class), (TypeReference)new TypeReference<IngestEvent>(){});
        }
        catch (JsonProcessingException e) {
            throw new LiveIngesterRuntimeException("Event deserialization failed", e);
        }
    }

    @Generated
    public IngestEventListener(ObjectMapper objectMapper, IngestEventProcessor eventProcessor, IntegrationProperties integrationProperties) {
        this.objectMapper = objectMapper;
        this.eventProcessor = eventProcessor;
        this.integrationProperties = integrationProperties;
    }
}

