/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.property;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.property.PropertyMappingHelper;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.AuthorityTypeResolver;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.springframework.stereotype.Component;

@Component
public class PropertiesMapper {
    private final AuthorityTypeResolver authorityTypeResolver;

    public Set<PropertyDelta<?>> mapToPropertyDeltas(RepoEvent<DataAttributes<NodeResource>> event) {
        Stream<PropertyDelta<?>> customProperties = this.calculateCustomPropertiesDelta(event);
        List<Optional<PropertyDelta<?>>> knownProperties = List.of(PropertyMappingHelper.calculateNamePropertyDelta(event), PropertyMappingHelper.calculateTypeDelta(event), PropertyMappingHelper.calculateCreatedByDelta(event), PropertyMappingHelper.calculateModifiedAtDelta(event), PropertyMappingHelper.calculateModifiedByDelta(event), PropertyMappingHelper.calculateAspectsDelta(event), PropertyMappingHelper.calculateCreatedAtDelta(event), PropertyMappingHelper.calculateAncestorsPropertyDelta(event), PropertyMappingHelper.calculatePermissionsPropertyDelta(event, this.authorityTypeResolver));
        return Stream.of(customProperties, knownProperties.stream().flatMap(Optional::stream), PropertyMappingHelper.calculateContentPropertyDelta(event).stream()).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    private Stream<PropertyDelta<?>> calculateCustomPropertiesDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        return this.streamProperties((NodeResource)event.getData().getResource()).filter(property -> property.getValue() != null).map(property -> PropertyDelta.updated((String)property.getKey(), property.getValue()));
    }

    private Stream<Map.Entry<String, ?>> streamProperties(NodeResource node) {
        return Optional.ofNullable(node).map(NodeResource::getProperties).stream().flatMap(properties -> properties.entrySet().stream());
    }

    @Generated
    public PropertiesMapper(AuthorityTypeResolver authorityTypeResolver) {
        this.authorityTypeResolver = authorityTypeResolver;
    }
}

