/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.property;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.AuthorityInfo;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.AuthorityTypeResolver;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.repo.event.v1.model.ContentInfo;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.UserInfo;

public class PropertyMappingHelper {
    private static final String GROUP_EVERYONE = "GROUP_EVERYONE";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static Optional<PropertyDelta<?>> calculatePropertyDelta(RepoEvent<DataAttributes<NodeResource>> event, String propertyKey, Function<NodeResource, ?> fieldGetter) {
        return Optional.ofNullable((NodeResource)event.getData().getResource()).map(fieldGetter).map(propertyValue -> PropertyDelta.updated(propertyKey, propertyValue));
    }

    public static Optional<PropertyDelta<?>> calculateNamePropertyDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        return PropertyMappingHelper.calculatePropertyDelta(event, "cm:name", NodeResource::getName);
    }

    public static Optional<PropertyDelta<?>> calculateTypeDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        return PropertyMappingHelper.calculatePropertyDelta(event, "type", NodeResource::getNodeType);
    }

    public static Optional<PropertyDelta<?>> calculateCreatedByDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        return PropertyMappingHelper.calculatePropertyDelta(event, "createdBy", nodeResource -> PropertyMappingHelper.getUserId(nodeResource, NodeResource::getCreatedByUser));
    }

    public static Optional<PropertyDelta<?>> calculateModifiedByDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        return PropertyMappingHelper.calculatePropertyDelta(event, "modifiedBy", nodeResource -> PropertyMappingHelper.getUserId(nodeResource, NodeResource::getModifiedByUser));
    }

    public static Optional<PropertyDelta<?>> calculateAspectsDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        return PropertyMappingHelper.calculatePropertyDelta(event, "aspectsNames", NodeResource::getAspectNames);
    }

    public static Optional<PropertyDelta<?>> calculateCreatedAtDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        return PropertyMappingHelper.calculatePropertyDelta(event, "createdAt", nodeResource -> PropertyMappingHelper.formatDateTime(nodeResource.getCreatedAt()));
    }

    public static Optional<PropertyDelta<?>> calculateModifiedAtDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        return PropertyMappingHelper.calculatePropertyDelta(event, "modifiedAt", nodeResource -> PropertyMappingHelper.formatDateTime(nodeResource.getModifiedAt()));
    }

    public static Optional<PropertyDelta<?>> calculateAncestorsPropertyDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        List primaryHierarchy = ((NodeResource)event.getData().getResource()).getPrimaryHierarchy();
        if (primaryHierarchy == null || primaryHierarchy.isEmpty()) {
            return Optional.empty();
        }
        String primaryParentId = (String)primaryHierarchy.get(0);
        ArrayList reversedHierarchy = new ArrayList(primaryHierarchy);
        Collections.reverse(reversedHierarchy);
        HashMap<String, Object> ancestorsData = new HashMap<String, Object>();
        ancestorsData.put("primaryParentId", primaryParentId);
        ancestorsData.put("primaryAncestorIds", reversedHierarchy);
        return Optional.of(PropertyDelta.updated("ancestors", ancestorsData));
    }

    public static Optional<PropertyDelta<?>> calculatePermissionsPropertyDelta(RepoEvent<DataAttributes<NodeResource>> event, AuthorityTypeResolver authorityTypeResolver) {
        EventData eventData = (EventData)event.getData();
        if ((eventData.getResourceReaderAuthorities() == null || eventData.getResourceReaderAuthorities().isEmpty()) && (eventData.getResourceDeniedAuthorities() == null || eventData.getResourceDeniedAuthorities().isEmpty())) {
            return Optional.empty();
        }
        Set allowAccess = eventData.getResourceReaderAuthorities() == null ? Set.of(GROUP_EVERYONE) : eventData.getResourceReaderAuthorities();
        Set denyAccess = eventData.getResourceDeniedAuthorities() == null ? Collections.emptySet() : eventData.getResourceDeniedAuthorities();
        List<AuthorityInfo> allowAccessWithTypes = PropertyMappingHelper.convertToAuthorityInfoList(allowAccess, authorityTypeResolver);
        List<AuthorityInfo> denyAccessWithTypes = PropertyMappingHelper.convertToAuthorityInfoList(denyAccess, authorityTypeResolver);
        return Optional.of(PropertyDelta.permissionsMetadataUpdated("PERMISSIONS", allowAccessWithTypes, denyAccessWithTypes));
    }

    public static List<AuthorityInfo> convertToAuthorityInfoList(Collection<String> authorities, AuthorityTypeResolver authorityTypeResolver) {
        if (authorities == null || authorities.isEmpty()) {
            return Collections.emptyList();
        }
        return authorities.stream().map(authorityId -> new AuthorityInfo((String)authorityId, authorityTypeResolver.resolveAuthorityType((String)authorityId))).collect(Collectors.toList());
    }

    private static String formatDateTime(ZonedDateTime time) {
        return time == null ? null : DATE_TIME_FORMATTER.format(time);
    }

    public static Optional<PropertyDelta<?>> calculateContentPropertyDelta(RepoEvent<DataAttributes<NodeResource>> event) {
        Optional<ContentInfo> contentInfo = Optional.ofNullable(((NodeResource)event.getData().getResource()).getContent());
        String sourceFileName = ((NodeResource)event.getData().getResource()).getName();
        String sourceMimeType = contentInfo.map(ContentInfo::getMimeType).orElse(null);
        Long sourceSizeInBytes = contentInfo.map(ContentInfo::getSizeInBytes).orElse(null);
        if (sourceMimeType == null && sourceSizeInBytes == null) {
            return Optional.empty();
        }
        return Optional.of(PropertyDelta.contentMetadataUpdated("cm:content", sourceMimeType, sourceSizeInBytes, sourceFileName));
    }

    private static String getUserId(NodeResource node, Function<NodeResource, UserInfo> userInfoGetter) {
        return Optional.ofNullable(node).map(userInfoGetter).map(UserInfo::getId).orElse(null);
    }

    @Generated
    private PropertyMappingHelper() {
    }
}

