/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.transform.storage;

import java.io.InputStream;
import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.common.util.ErrorUtils;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.util.LoggingUtils;
import org.alfresco.hxi_connector.live_ingester.domain.exception.LiveIngesterRuntimeException;
import org.alfresco.hxi_connector.live_ingester.domain.ports.transform_engine.TransformEngineFileStorage;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.model.File;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.event.Level;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class SharedFileStoreClient
extends RouteBuilder
implements TransformEngineFileStorage {
    private static final String LOCAL_ENDPOINT = "direct:" + SharedFileStoreClient.class.getSimpleName();
    private static final String ROUTE_ID = "rendition-downloader";
    private static final int EXPECTED_STATUS_CODE = 200;
    private static final String FILE_ID_HEADER = "fileId";
    private static final String ENDPOINT_PATTERN = "%s/${headers.fileId}?httpMethod=GET&throwExceptionOnFailure=false";
    private final CamelContext camelContext;
    private final IntegrationProperties integrationProperties;

    public void configure() {
        String fileEndpoint = ENDPOINT_PATTERN.formatted(this.integrationProperties.alfresco().transform().sharedFileStore().fileEndpoint());
        ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).log(LoggingLevel.ERROR, this.log, "Transform :: Unexpected response while downloading rendition - Endpoint: %s".formatted(fileEndpoint))).process(exchange -> LoggingUtils.logMaskedExchangeState(exchange, this.log, Level.ERROR))).process(this::wrapErrorIfNecessary)).stop();
        ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.from(LOCAL_ENDPOINT).id(ROUTE_ID)).toD(fileEndpoint)).choice().when(this.header("CamelHttpResponseCode").isEqualTo((Object)String.valueOf(200))).process(this::convertBodyToFile)).otherwise().process(this::throwExceptionOnUnexpectedStatusCode)).endChoice().end();
    }

    @Override
    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{@integrationProperties.alfresco.transform.sharedFileStore.retry.attempts}", backoff=@Backoff(delayExpression="#{@integrationProperties.alfresco.transform.sharedFileStore.retry.initialDelay}", multiplierExpression="#{@integrationProperties.alfresco.transform.sharedFileStore.retry.delayMultiplier}"))
    public File downloadFile(String fileId) {
        return (File)this.camelContext.createFluentProducerTemplate().to(LOCAL_ENDPOINT).withHeader(FILE_ID_HEADER, (Object)fileId).request(File.class);
    }

    private void convertBodyToFile(Exchange exchange) {
        exchange.getMessage().setBody((Object)new File((InputStream)exchange.getIn().getBody(InputStream.class)), File.class);
    }

    private void throwExceptionOnUnexpectedStatusCode(Exchange exchange) {
        int actualStatusCode = (Integer)exchange.getMessage().getHeader("CamelHttpResponseCode", Integer.class);
        if (actualStatusCode != 200) {
            this.log.warn("Unexpected response status code - expecting: %d, received: %d".formatted(200, actualStatusCode));
        }
        ErrorUtils.throwExceptionOnUnexpectedStatusCode((int)actualStatusCode, (int)200);
    }

    private void wrapErrorIfNecessary(Exchange exchange) {
        Exception cause = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        Set retryReasons = this.integrationProperties.alfresco().transform().sharedFileStore().retry().reasons();
        ErrorUtils.wrapErrorAndThrowIfNecessary((Exception)cause, (Set)retryReasons, LiveIngesterRuntimeException.class);
    }

    @Generated
    public SharedFileStoreClient(CamelContext camelContext, IntegrationProperties integrationProperties) {
        this.camelContext = camelContext;
        this.integrationProperties = integrationProperties;
    }
}

