/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper;

import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.MimeTypeMapper;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.property.PropertiesMapper;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.EventUtils;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.TriggerContentIngestionCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.delete.DeleteNodeCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.IngestNodeCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.EventType;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.springframework.stereotype.Component;

@Component
public class RepoEventMapper {
    private final PropertiesMapper propertiesMapper;
    private final MimeTypeMapper mimeTypeMapper;

    public TriggerContentIngestionCommand mapToIngestContentCommand(RepoEvent<DataAttributes<NodeResource>> event) {
        EnsureUtils.ensureThat((EventUtils.isEventTypeCreated(event) || EventUtils.isEventTypeUpdated(event) ? 1 : 0) != 0, (String)"Unsupported event type", (Object[])new Object[0]);
        NodeResource resource = (NodeResource)event.getData().getResource();
        String mimeType = this.mimeTypeMapper.mapMimeType(resource.getContent().getMimeType());
        return new TriggerContentIngestionCommand(resource.getId(), mimeType, EventUtils.getEventTimestamp(event));
    }

    public IngestNodeCommand mapToIngestNodeCommand(RepoEvent<DataAttributes<NodeResource>> event) {
        EventType eventType = EventUtils.getEventType(event);
        EnsureUtils.ensureThat((eventType == EventType.CREATE_OR_UPDATE ? 1 : 0) != 0, (String)"Unsupported event type", (Object[])new Object[0]);
        return new IngestNodeCommand(((NodeResource)event.getData().getResource()).getId(), eventType, this.propertiesMapper.mapToPropertyDeltas(event), EventUtils.getEventTimestamp(event));
    }

    public DeleteNodeCommand mapToDeleteNodeCommand(RepoEvent<DataAttributes<NodeResource>> event) {
        EnsureUtils.ensureThat((boolean)EventUtils.isEventTypeDeleted(event), (String)"Only delete events can be converted to delete commands", (Object[])new Object[0]);
        return new DeleteNodeCommand(((NodeResource)event.getData().getResource()).getId(), EventUtils.getEventTimestamp(event));
    }

    @Generated
    public RepoEventMapper(PropertiesMapper propertiesMapper, MimeTypeMapper mimeTypeMapper) {
        this.propertiesMapper = propertiesMapper;
        this.mimeTypeMapper = mimeTypeMapper;
    }
}

