/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata;

import java.util.Set;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.EventType;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;

public record IngestNodeCommand(String nodeId, EventType eventType, Set<PropertyDelta<?>> properties, long sourceTimestamp) {
    public IngestNodeCommand {
        EnsureUtils.ensureNotBlank((String)nodeId, (String)"Node id cannot be blank", (Object[])new Object[0]);
        EnsureUtils.ensureNonNull((Object)((Object)eventType), (String)"Node %s event type cannot be null", (Object[])new Object[]{nodeId});
        EnsureUtils.ensureNonNull(properties, (String)"Node %s properties delta cannot be null", (Object[])new Object[]{nodeId});
        EnsureUtils.ensureThat((sourceTimestamp > 0L ? 1 : 0) != 0, (String)"Source sourceTimestamp cannot be negative or zero.", (Object[])new Object[0]);
    }
}

