/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.filter;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.alfresco.hxi_connector.common.repository.filter.CollectionFilter;
import org.alfresco.hxi_connector.live_ingester.adapters.config.properties.Filter;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.filter.RepoEventFilterApplier;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AncestorFilterApplier
implements RepoEventFilterApplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AncestorFilterApplier.class);

    @Override
    public boolean isNodeAllowed(NodeResource nodeResource, Filter filter) {
        ArrayList<String> primaryHierarchy = new ArrayList<String>(ListUtils.emptyIfNull((List)nodeResource.getPrimaryHierarchy()));
        primaryHierarchy.add(nodeResource.getId());
        List<String> allowed = filter.path().allow();
        List<String> denied = filter.path().deny();
        log.atDebug().log("Filtering :: Applying ancestor filters on repo node id: {}", (Object)nodeResource.getId());
        return CollectionFilter.filter(primaryHierarchy, allowed, denied);
    }

    @Override
    public boolean isNodeBeforeAllowed(boolean currentlyAllowed, NodeResource nodeResourceBefore, Filter filter) {
        log.atDebug().log("Filtering :: Applying ancestor filters on previous version of repo node id: {}", (Object)nodeResourceBefore.getId());
        List primaryHierarchy = nodeResourceBefore.getPrimaryHierarchy();
        if (primaryHierarchy == null) {
            return currentlyAllowed;
        }
        return this.isNodeAllowed(nodeResourceBefore, filter);
    }

    @Generated
    public AncestorFilterApplier() {
    }
}

