/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.nucleus_sync.client.ClientException;
import org.alfresco.hxi_connector.nucleus_sync.dto.AlfrescoGroup;
import org.alfresco.hxi_connector.nucleus_sync.dto.AlfrescoPagedResponse;
import org.alfresco.hxi_connector.nucleus_sync.dto.AlfrescoUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class AlfrescoClient {
    private final WebClient webClient;
    private final ObjectMapper objectMapper;
    private final AuthService authService;
    private final String alfrescoBaseUrl;
    private final int timeoutInMins;
    private final int pageSize;
    private final boolean skipNotEnabled;
    private static final Logger LOGGER = LoggerFactory.getLogger(AlfrescoClient.class);

    @Autowired
    public AlfrescoClient(AuthService authService, @Value(value="${alfresco.base-url}") String alfrescoBaseUrl, @Value(value="${http-client.timeout-minutes:5}") int timeoutInMins, @Value(value="${http-client.buffer-size-kilobytes:10240}") int bufferInKB, @Value(value="${alfresco.page-size:100}") int pageSize, @Value(value="${alfresco.user.skip-not-enabled:true}") boolean skipNotEnabled) {
        this(WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(bufferInKB * 1024)).build(), new ObjectMapper(), authService, timeoutInMins, alfrescoBaseUrl, pageSize, skipNotEnabled);
    }

    AlfrescoClient(WebClient webClient, ObjectMapper objectMapper, AuthService authService, int timeoutInMins, String alfrescoBaseUrl, int pageSize, boolean skipNotEnabled) {
        this.webClient = webClient;
        this.objectMapper = objectMapper;
        this.authService = authService;
        this.timeoutInMins = timeoutInMins;
        this.alfrescoBaseUrl = alfrescoBaseUrl;
        this.pageSize = pageSize;
        this.skipNotEnabled = skipNotEnabled;
    }

    public List<AlfrescoUser> getAllUsers() {
        List users = this.fetchAllPagedData("/people?fields=id,email,enabled&", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, "users");
        return this.skipNotEnabled ? users.stream().filter(AlfrescoUser::enabled).collect(Collectors.toList()) : users;
    }

    public List<String> getUserGroups(String userId) {
        List groups = this.fetchAllPagedData("/people/" + userId + "/groups?fields=id&", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, "groups for user " + userId);
        return groups.stream().map(AlfrescoGroup::id).toList();
    }

    private <T> List<T> fetchAllPagedData(String basePath, TypeReference<AlfrescoPagedResponse<T>> typeRef, String errorContext) {
        try {
            ArrayList results = new ArrayList();
            int skipCount = 0;
            boolean hasMoreItems = true;
            while (hasMoreItems) {
                AlfrescoPagedResponse.Pagination pagination;
                String response = (String)this.makeAuthenticatedRequest(basePath + "maxItems=" + this.pageSize + "&skipCount=" + skipCount).bodyToMono(String.class).block(Duration.ofMinutes(this.timeoutInMins));
                AlfrescoPagedResponse pagedResponse = (AlfrescoPagedResponse)this.objectMapper.readValue(response, typeRef);
                if (pagedResponse.getList() != null && pagedResponse.getList().entries() != null) {
                    pagedResponse.getList().entries().stream().map(AlfrescoPagedResponse.EntryWrapper::entry).filter(entry -> entry != null).forEach(results::add);
                }
                if ((pagination = pagedResponse.getList().pagination()) != null) {
                    hasMoreItems = pagination.hasMoreItems();
                    skipCount += pagination.count();
                    continue;
                }
                hasMoreItems = false;
            }
            return results;
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error fetching {}: {}").addArgument((Object)errorContext).addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to fetch " + errorContext, (Throwable)e);
        }
    }

    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{${http-client.max-attempts:3}}", backoff=@Backoff(delayExpression="#{${http-client.initial-delay-ms:2000}}", multiplierExpression="#{${http-client.multiplier:2}}", maxDelayExpression="#{${http-client.max-delay-ms:10000}}"))
    private WebClient.ResponseSpec makeAuthenticatedRequest(String path) {
        Map headers = this.authService.getAlfrescoAuthHeaders();
        return this.webClient.get().uri(this.alfrescoBaseUrl + path, new Object[0]).headers(httpHeaders -> headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1))).retrieve();
    }
}

