/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.nucleus_sync.client.ClientException;
import org.alfresco.hxi_connector.nucleus_sync.dto.IamUser;
import org.alfresco.hxi_connector.nucleus_sync.dto.IamUsersOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupInput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupListOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupMemberAssignmentInput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupMembershipListOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupMembershipOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusGroupOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusPagedResponse;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusUserMappingInput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusUserMappingListOutput;
import org.alfresco.hxi_connector.nucleus_sync.dto.NucleusUserMappingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class NucleusClient {
    private final WebClient webClient;
    private final ObjectMapper objectMapper;
    private final AuthService authService;
    private final String systemId;
    private final String nucleusBaseUrl;
    private final String idpBaseUrl;
    private final int pageSize;
    private final int timeoutInMin;
    private final int deleteBatchSize;
    private static final Logger LOGGER = LoggerFactory.getLogger(NucleusClient.class);

    @Autowired
    public NucleusClient(AuthService authService, @Value(value="${nucleus.system-id}") String systemId, @Value(value="${nucleus.base-url}") String nucleusBaseUrl, @Value(value="${nucleus.idp-base-url}") String idpBaseUrl, @Value(value="${nucleus.page-size:1000}") int pageSize, @Value(value="${nucleus.delete-group-member-batch-size:100}") int deleteBatchSize, @Value(value="${http-client.timeout-minutes:5}") int timeoutInMins, @Value(value="${http-client.buffer-size-kilobytes:10240}") int bufferInKB) {
        this(WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(bufferInKB * 1024)).build(), new ObjectMapper(), authService, systemId, nucleusBaseUrl, idpBaseUrl, pageSize, deleteBatchSize, timeoutInMins);
    }

    NucleusClient(WebClient webClient, ObjectMapper objectMapper, AuthService authService, String systemId, String nucleusBaseUrl, String idpBaseUrl, int pageSize, int deleteBatchSize, int timeoutInMin) {
        this.webClient = webClient;
        this.objectMapper = objectMapper;
        this.authService = authService;
        this.systemId = systemId;
        this.nucleusBaseUrl = nucleusBaseUrl;
        this.idpBaseUrl = idpBaseUrl;
        this.pageSize = pageSize;
        this.timeoutInMin = timeoutInMin;
        this.deleteBatchSize = deleteBatchSize;
    }

    public List<IamUser> getAllIamUsers() {
        String initialPath = "/api/users";
        try {
            return this.fetchAllPages(this.idpBaseUrl, initialPath, "users", IamUsersOutput.class);
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in retrieving iam users: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to retrieve iam users", e);
        }
    }

    public List<NucleusGroupOutput> getAllExternalGroups() {
        String initialPath = "/system-integrations/systems/" + this.systemId + "/groups";
        try {
            return this.fetchAllPages(this.nucleusBaseUrl, initialPath, "groups", NucleusGroupListOutput.class);
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in retrieving groups: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to retrieve groups", e);
        }
    }

    public void createGroups(List<NucleusGroupInput> groups) {
        String url = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/groups";
        try {
            String jsonBody = this.objectMapper.writeValueAsString(groups);
            this.executePostRequest(url, jsonBody);
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in creating groups in nucleus: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to create groups in nucleus", e);
        }
    }

    public List<NucleusUserMappingOutput> getCurrentUserMappings() {
        String initialPath = "/system-integrations/systems/" + this.systemId + "/user-mappings";
        try {
            return this.fetchAllPages(this.nucleusBaseUrl, initialPath, "user mappings", NucleusUserMappingListOutput.class);
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in retrieving user mappings: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to retrieve user mappings", e);
        }
    }

    public void createUserMappings(List<NucleusUserMappingInput> userMappings) {
        String url = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/user-mappings";
        try {
            String jsonBody = this.objectMapper.writeValueAsString(userMappings);
            this.executePostRequest(url, jsonBody);
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in creating user mappings: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to create user mappings", e);
        }
    }

    public List<NucleusGroupMembershipOutput> getCurrentGroupMemberships() {
        String initalPath = "/system-integrations/systems/" + this.systemId + "/group-members";
        try {
            return this.fetchAllPages(this.nucleusBaseUrl, initalPath, "group memberships", NucleusGroupMembershipListOutput.class);
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in retrieving group memberships: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to retrieve group memberships", e);
        }
    }

    public void assignGroupMembers(List<NucleusGroupMemberAssignmentInput> assignments) {
        String url = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/group-members";
        try {
            String jsonBody = this.objectMapper.writeValueAsString(assignments);
            this.executePostRequest(url, jsonBody);
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in creating member assignments to group: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Error in creating member assignments to group", e);
        }
    }

    public void deleteGroup(String externalGroupId) {
        try {
            String fullUrl = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/groups/" + URLEncoder.encode(externalGroupId, StandardCharsets.UTF_8);
            this.executeDeleteRequest(fullUrl);
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in deleting group: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to delete group", e);
        }
    }

    public void deleteUserMapping(String externalUserId) {
        try {
            String fullUrl = this.nucleusBaseUrl + "/system-integrations/systems/" + this.systemId + "/user-mappings/" + URLEncoder.encode(externalUserId, StandardCharsets.UTF_8);
            this.executeDeleteRequest(fullUrl);
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in deleting user mapping: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to delete user mappings", e);
        }
    }

    public void removeGroupMembers(String parentExternalGroupId, List<String> memberExternalUserIds) {
        try {
            for (int i = 0; i < memberExternalUserIds.size(); i += this.deleteBatchSize) {
                List<String> batch = memberExternalUserIds.subList(i, Math.min(i + this.deleteBatchSize, memberExternalUserIds.size()));
                this.removeGroupMembersBatch(parentExternalGroupId, batch);
            }
        }
        catch (Exception e) {
            LOGGER.atError().setMessage("Error in removing group members: {}").addArgument((Object)e.getMessage()).setCause((Throwable)e).log();
            throw new ClientException("Failed to remove group members", e);
        }
    }

    private void removeGroupMembersBatch(String parentExternalGroupId, List<String> batch) {
        StringBuilder urlBuilder = new StringBuilder(this.nucleusBaseUrl).append("/system-integrations/systems/").append(this.systemId).append("/group-members").append("?parentExternalGroupId=").append(URLEncoder.encode(parentExternalGroupId, StandardCharsets.UTF_8));
        for (String userId : batch) {
            urlBuilder.append("&memberExternalUserIds=").append(URLEncoder.encode(userId, StandardCharsets.UTF_8));
        }
        this.executeDeleteRequest(urlBuilder.toString());
    }

    private <T, R extends NucleusPagedResponse<T>> List<T> fetchAllPages(String baseUrl, String initialPath, String context, Class<R> responseType) throws JsonProcessingException {
        ArrayList allItems = new ArrayList();
        String nextPath = UriComponentsBuilder.fromUriString((String)initialPath).queryParam("limit", new Object[]{this.pageSize}).toUriString();
        int pageCount = 0;
        while (nextPath != null) {
            LOGGER.atTrace().setMessage("Fetching page {} of nucleus {}").addArgument((Object)(++pageCount)).addArgument((Object)context).log();
            String fullUrl = baseUrl + nextPath;
            String response = this.executeGetRequest(fullUrl);
            NucleusPagedResponse page = (NucleusPagedResponse)this.objectMapper.readValue(response, responseType);
            if (page.items() != null && !page.items().isEmpty()) {
                allItems.addAll(page.items());
            }
            nextPath = page.next();
        }
        LOGGER.atDebug().setMessage("Retrieved {} total {} across {} pages").addArgument((Object)allItems.size()).addArgument((Object)context).addArgument((Object)pageCount).log();
        return allItems;
    }

    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{${http-client.max-attempts:3}}", backoff=@Backoff(delayExpression="#{${http-client.initial-delay-ms:2000}}", multiplierExpression="#{${http-client.multiplier:2}}", maxDelayExpression="#{${http-client.max-delay-ms:10000}}"))
    private String executeGetRequest(String fullUrl) {
        Map headers = this.authService.getHxpAuthHeaders();
        return (String)this.webClient.get().uri(fullUrl, new Object[0]).headers(httpHeaders -> {
            headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1));
            httpHeaders.set("Content-Type", "application/json");
        }).retrieve().bodyToMono(String.class).block(Duration.ofMinutes(this.timeoutInMin));
    }

    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{${http-client.max-attempts:3}}", backoff=@Backoff(delayExpression="#{${http-client.initial-delay-ms:2000}}", multiplierExpression="#{${http-client.multiplier:2}}", maxDelayExpression="#{${http-client.max-delay-ms:10000}}"))
    private String executePostRequest(String fullUrl, String jsonBody) {
        Map headers = this.authService.getHxpAuthHeaders();
        return (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(fullUrl, new Object[0])).contentType(MediaType.APPLICATION_JSON).headers(httpHeaders -> headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1)))).bodyValue((Object)jsonBody).retrieve().bodyToMono(String.class).block(Duration.ofMinutes(this.timeoutInMin));
    }

    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{${http-client.max-attempts:3}}", backoff=@Backoff(delayExpression="#{${http-client.initial-delay-ms:2000}}", multiplierExpression="#{${http-client.multiplier:2}}", maxDelayExpression="#{${http-client.max-delay-ms:10000}}"))
    private String executeDeleteRequest(String fullUrl) {
        Map headers = this.authService.getHxpAuthHeaders();
        return (String)this.webClient.delete().uri(fullUrl, new Object[0]).headers(httpHeaders -> headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1))).retrieve().bodyToMono(String.class).block(Duration.ofMinutes(this.timeoutInMin));
    }
}

