/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.services.orchestration;

import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.SyncOrchestrationService;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.SyncException;
import org.alfresco.hxi_connector.nucleus_sync.services.orchestration.exceptions.SyncInProgressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class SyncSchedulerService {
    private final SyncOrchestrationService syncOrchestrationService;
    private final boolean syncEnabled;
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSchedulerService.class);

    public SyncSchedulerService(@Value(value="${sync.enabled}") boolean syncEnabled, SyncOrchestrationService syncOrchestrationService) {
        this.syncEnabled = syncEnabled;
        this.syncOrchestrationService = syncOrchestrationService;
    }

    @Scheduled(cron="${sync.cron.expression}")
    public void scheduledSync() {
        if (!this.syncEnabled) {
            LOGGER.atDebug().setMessage("Scheduled sync skipped - sync disabled").log();
            return;
        }
        LOGGER.atInfo().setMessage("Starting scheduled sync...").log();
        try {
            String result = this.syncOrchestrationService.performFullSync();
            LOGGER.atInfo().setMessage("Scheduled sync completed: {}").addArgument((Object)result).log();
        }
        catch (SyncInProgressException e) {
            LOGGER.atWarn().setMessage("Scheduled sync skipped - previous sync still running").log();
        }
        catch (SyncException e) {
            LOGGER.atWarn().setMessage("Scheduled sync failed - see previous logs for details").log();
        }
    }
}

